/*
 * Decompiled with CFR 0.152.
 */
package cn.jcasbin.subject;

import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.web.subject.support.WebDelegatingSubject;
import org.casbin.jcasbin.main.Enforcer;

public class CasbinSubject
extends WebDelegatingSubject {
    private final Enforcer enforcer;

    public CasbinSubject(PrincipalCollection principals, boolean authenticated, String host, Session session, ServletRequest request, ServletResponse response, SecurityManager securityManager, Enforcer enforcer) {
        super(principals, authenticated, host, session, request, response, securityManager);
        this.enforcer = enforcer;
    }

    public boolean enforce(Object ... rvals) throws AuthorizationException {
        if (rvals == null) {
            throw new NullPointerException("rvals is marked non-null but is null");
        }
        this.assertAuthzCheckPossible();
        return this.enforcer.enforce(rvals);
    }

    public boolean hasRole(String roleIdentifier) {
        return this.hasPrincipals() && this.enforcer.hasRoleForUser(this.principals.toString(), roleIdentifier);
    }

    public List<List<String>> getPermissionsForUser() {
        if (this.hasPrincipals()) {
            return this.enforcer.getPermissionsForUser(this.principals.toString());
        }
        return null;
    }

    public List<String> getRolesForUser() {
        if (this.hasPrincipals()) {
            return this.enforcer.getRolesForUser(this.principals.toString());
        }
        return null;
    }

    public Enforcer getEnforcer() {
        return this.enforcer;
    }
}

