/*
 * Decompiled with CFR 0.152.
 */
package cn.jcasbin.autoconfigure;

import cn.jcasbin.adapter.HutoolDBAdapter;
import cn.jcasbin.advisor.CasbinAdvisor;
import cn.jcasbin.properties.CasbinProperties;
import cn.jcasbin.subject.CasbinDefaultWebSubjectFactory;
import cn.jcasbin.watcher.EtcdWatcher;
import io.etcd.jetcd.Client;
import javax.sql.DataSource;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.spring.boot.autoconfigure.ShiroAutoConfiguration;
import org.apache.shiro.spring.config.web.autoconfigure.ShiroWebAutoConfiguration;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ResourceUtils;

@Configuration
@EnableConfigurationProperties(value={CasbinProperties.class})
@AutoConfigureBefore(value={ShiroWebAutoConfiguration.class, ShiroAutoConfiguration.class})
@ConditionalOnProperty(prefix="shiro-jcasbin", value={"enabled"}, matchIfMissing=true)
public class CasbinAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CasbinAutoConfiguration.class);
    @Autowired
    private CasbinProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public SubjectFactory subjectFactory(DataSource dataSource, Client client) {
        Model model = new Model();
        model.loadModel(ResourceUtils.getFile((String)this.properties.getModel()).getPath());
        Enforcer enforcer = new Enforcer(model, (Adapter)new HutoolDBAdapter(dataSource, this.properties.getRuleTable()));
        if (client != null && this.properties.getWatcher().booleanValue()) {
            EtcdWatcher watcher = new EtcdWatcher(client, this.properties.getWatcherKey());
            enforcer.setWatcher((Watcher)watcher);
            watcher.startWatch();
        }
        return new CasbinDefaultWebSubjectFactory(enforcer);
    }

    @Bean
    public CasbinAdvisor casbinAdvisor() {
        return new CasbinAdvisor();
    }
}

