/*
 * Decompiled with CFR 0.152.
 */
package cn.wellt.mqtt.config;

import cn.wellt.mqtt.annotation.EnableMqttListener;
import cn.wellt.mqtt.annotation.MqttListener;
import cn.wellt.mqtt.config.MqttMessageListenerHolder;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MqttMessageListenerRegister
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware,
BeanClassLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(MqttMessageListenerRegister.class);
    private ResourceLoader resourceLoader;
    private Environment environment;
    private ClassLoader classLoader;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Set<String> basePackages = this.getBasePackages(importingClassMetadata);
        ClassPathScanningCandidateComponentProvider scanner = this.getScanner();
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MqttListener.class));
        for (String basePackage : basePackages) {
            Set candidateComponents = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition candidateComponent : candidateComponents) {
                if (!(candidateComponent instanceof AnnotatedBeanDefinition)) continue;
                AnnotatedBeanDefinition beanDefinition = (AnnotatedBeanDefinition)candidateComponent;
                AnnotationMetadata annotationMetadata = beanDefinition.getMetadata();
                this.registerMessageHandler(annotationMetadata, registry);
            }
        }
        ClassPathBeanDefinitionScanner realScanner = new ClassPathBeanDefinitionScanner(registry);
        realScanner.setResourceLoader(this.resourceLoader);
        realScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MqttListener.class));
        realScanner.scan(basePackages.toArray(new String[0]));
    }

    public void registerMessageHandler(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map attributes = metadata.getAnnotationAttributes(MqttListener.class.getCanonicalName());
        String topic = attributes.get("topic").toString();
        String listenerName = metadata.getClassName();
        int qos = Integer.parseInt(attributes.get("qos").toString());
        MqttMessageListenerHolder.register(attributes.get("topic").toString(), metadata.getClassName(), qos);
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        return new ClassPathScanningCandidateComponentProvider(false, this.environment){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                if (beanDefinition.getMetadata().isIndependent()) {
                    if (beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().getInterfaceNames().length == 1 && Annotation.class.getName().equals(beanDefinition.getMetadata().getInterfaceNames()[0])) {
                        try {
                            Class target = ClassUtils.forName((String)beanDefinition.getMetadata().getClassName(), (ClassLoader)MqttMessageListenerRegister.this.classLoader);
                            return !target.isAnnotation();
                        }
                        catch (Exception ex) {
                            log.error("Could not load target class: " + beanDefinition.getMetadata().getClassName(), (Throwable)ex);
                        }
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableMqttListener.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        if (attributes.containsKey("basePackages")) {
            for (String pkg : (String[])attributes.get("basePackages")) {
                if (!StringUtils.hasText((String)pkg)) continue;
                basePackages.add(pkg);
            }
        }
        if (attributes.containsKey("basePackageClasses")) {
            for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
                basePackages.add(ClassUtils.getPackageName((Class)clazz));
            }
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

