/*
 * Decompiled with CFR 0.152.
 */
package cn.wellt.mqtt.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class MqttMessageListenerHolder {
    private static Map<String, String> listeners = new ConcurrentHashMap<String, String>();
    private static Map<String, Integer> qoss = new ConcurrentHashMap<String, Integer>();
    private static TopicSubscribeTree tree = new TopicSubscribeTree();

    public static void register(String topic, String listenerName, int qos) {
        if (!StringUtils.hasText((String)listenerName)) {
            return;
        }
        listeners.putIfAbsent(topic, listenerName);
        qoss.putIfAbsent(topic, qos);
        MqttMessageListenerHolder.insertTree(topic, qos);
    }

    public static String getListener(String topic) {
        return listeners.get(MqttMessageListenerHolder.translateSubscribeName(topic));
    }

    public static Map<String, String> getListeners() {
        return listeners;
    }

    public static Map<String, Integer> getQoss() {
        return qoss;
    }

    private static void insertTree(String topic, int qos) {
        TopicSubscribeTree cur = tree;
        String[] levels = topic.split("/");
        for (int i = 0; i < levels.length; ++i) {
            TopicSubscribeTree newTree;
            String level = levels[i];
            if (null == cur.getChild()) {
                cur.setChild(new ConcurrentHashMap<String, TopicSubscribeTree>());
                newTree = new TopicSubscribeTree();
                newTree.setLevelName(level);
                cur.getChild().put(level, newTree);
                cur = newTree;
            } else {
                if (cur.getChild().containsKey(level)) {
                    cur = cur.getChild().get(level);
                    continue;
                }
                newTree = new TopicSubscribeTree();
                newTree.setLevelName(level);
                cur.getChild().put(level, newTree);
                cur = newTree;
            }
            if (levels.length - 1 != i) continue;
            cur.setQos(qos);
        }
    }

    private static String translateSubscribeName(String topic) {
        StringBuilder sb = new StringBuilder();
        TopicSubscribeTree cur = tree;
        while (null != cur.child) {
            String nextTopic;
            int firstIndex;
            if (!StringUtils.hasText((String)topic)) {
                if (cur.child.containsKey("#")) {
                    sb.append("/#");
                    return sb.toString();
                }
                if (cur.child.containsKey("+")) {
                    sb.append("/+");
                    return sb.toString();
                }
                return sb.toString();
            }
            if (0 != sb.length()) {
                sb.append("/");
            }
            String level = (firstIndex = topic.indexOf("/")) >= 0 ? topic.substring(0, topic.indexOf("/")) : topic;
            String string = nextTopic = topic.contains("/") ? topic.substring(topic.indexOf("/") + 1) : null;
            if (cur.child.containsKey("+")) {
                sb.append("+");
                topic = nextTopic;
                cur = (TopicSubscribeTree)cur.child.get("+");
                continue;
            }
            if (cur.child.containsKey("#")) {
                sb.append("#");
                return sb.toString();
            }
            sb.append(level);
            topic = nextTopic;
            cur = (TopicSubscribeTree)cur.child.get(level);
        }
        return sb.toString();
    }

    private static class TopicSubscribeTree {
        private String levelName;
        private Map<String, TopicSubscribeTree> child;
        private Integer qos;

        private TopicSubscribeTree() {
        }

        public String getLevelName() {
            return this.levelName;
        }

        public void setLevelName(String levelName) {
            this.levelName = levelName;
        }

        public Map<String, TopicSubscribeTree> getChild() {
            return this.child;
        }

        public void setChild(Map<String, TopicSubscribeTree> child) {
            this.child = child;
        }

        public Integer getQos() {
            return this.qos;
        }

        public void setQos(Integer qos) {
            this.qos = qos;
        }
    }
}

