/*
 * Decompiled with CFR 0.152.
 */
package cn.wellt.mqtt;

import cn.wellt.mqtt.callback.MqttMessageListener;
import cn.wellt.mqtt.config.MqttMessageListenerHolder;
import cn.wellt.mqtt.properties.MqttConfigProperties;
import cn.wellt.mqtt.util.SpringContextHolder;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.annotation.IntegrationComponentScan;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.mqtt.core.DefaultMqttPahoClientFactory;
import org.springframework.integration.mqtt.core.MqttPahoClientFactory;
import org.springframework.integration.mqtt.inbound.MqttPahoMessageDrivenChannelAdapter;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.StringUtils;

@Configuration
@IntegrationComponentScan
@ComponentScan(basePackages={"cn.wellt.mqtt.util"})
@ConditionalOnProperty(value={"mqtt.host"})
@EnableConfigurationProperties(value={MqttConfigProperties.class})
public class MqttAutoConfiguration {
    private final MqttConfigProperties configProperties;

    public MqttAutoConfiguration(MqttConfigProperties configProperties) {
        this.configProperties = configProperties;
    }

    @Bean
    public MqttConnectOptions getMqttConnectOptions() {
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setCleanSession(true);
        mqttConnectOptions.setConnectionTimeout(this.configProperties.getTimeout());
        mqttConnectOptions.setKeepAliveInterval(90);
        mqttConnectOptions.setAutomaticReconnect(true);
        if (StringUtils.hasText((String)this.configProperties.getUsername())) {
            mqttConnectOptions.setUserName(this.configProperties.getUsername());
        }
        if (StringUtils.hasText((String)this.configProperties.getPassword())) {
            mqttConnectOptions.setPassword(this.configProperties.getPassword().toCharArray());
        }
        mqttConnectOptions.setServerURIs(this.configProperties.getHost().split(","));
        return mqttConnectOptions;
    }

    @Bean
    public MqttPahoClientFactory mqttClientFactory() {
        DefaultMqttPahoClientFactory factory = new DefaultMqttPahoClientFactory();
        factory.setConnectionOptions(this.getMqttConnectOptions());
        return factory;
    }

    @Bean
    public MessageChannel mqttInboundChannel() {
        return new DirectChannel();
    }

    @Bean
    public MessageProducer mqttInboundAdaptor() {
        MqttPahoMessageDrivenChannelAdapter adapter = new MqttPahoMessageDrivenChannelAdapter(this.configProperties.getInboundClientPrefix() + Instant.now().getEpochSecond(), this.mqttClientFactory(), new String[0]);
        adapter.setCompletionTimeout((long)this.configProperties.getCompletionTimeout());
        adapter.setOutputChannel(this.mqttInboundChannel());
        DefaultPahoMessageConverter converter = new DefaultPahoMessageConverter();
        converter.setPayloadAsBytes(true);
        adapter.setConverter((MqttMessageConverter)converter);
        Map<String, String> topicMap = MqttMessageListenerHolder.getListeners();
        Map<String, Integer> qosMap = MqttMessageListenerHolder.getQoss();
        for (String topic : topicMap.keySet()) {
            Integer qos = qosMap.get(topic);
            adapter.addTopic(topic, qos.intValue());
        }
        return adapter;
    }

    @Bean
    @ServiceActivator(inputChannel="mqttInboundChannel")
    public MessageHandler mqttInboundMessageHandler() {
        return message -> {
            MessageHeaders headers = message.getHeaders();
            String topic = Objects.requireNonNull(headers.get((Object)"mqtt_receivedTopic")).toString();
            String listenerName = MqttMessageListenerHolder.getListener(topic);
            if (!StringUtils.hasText((String)listenerName)) {
                return;
            }
            MqttMessageListener listener = null;
            try {
                listener = (MqttMessageListener)SpringContextHolder.getBean(Class.forName(listenerName));
                MqttMessage mqttMessage = new MqttMessage((byte[])message.getPayload());
                mqttMessage.setId(Integer.parseInt(Objects.requireNonNull(headers.get((Object)"mqtt_id")).toString()));
                mqttMessage.setQos(Integer.parseInt(Objects.requireNonNull(headers.get((Object)"mqtt_receivedQos")).toString()));
                if (null != headers.get((Object)"mqtt_receivedRetained")) {
                    mqttMessage.setRetained(Boolean.parseBoolean(Objects.requireNonNull(headers.get((Object)"mqtt_receivedRetained")).toString()));
                }
                listener.onMessage(topic, mqttMessage);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        };
    }

    @Bean
    public MessageChannel mqttOutboundChannel() {
        return new DirectChannel();
    }

    @Bean
    @ServiceActivator(inputChannel="mqttOutboundChannel")
    public MessageHandler mqttOutbound() {
        MqttPahoMessageHandler messageHandler = new MqttPahoMessageHandler(this.configProperties.getOutboundClientPrefix() + Instant.now().getEpochSecond(), this.mqttClientFactory());
        messageHandler.setAsync(true);
        messageHandler.setDefaultTopic(this.configProperties.getDefaultTopic());
        return messageHandler;
    }
}

