/*
 * Decompiled with CFR 0.152.
 */
package cn.weiyinfu.tqdm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class Tqdm<T>
implements Iterable<T> {
    int total;
    int progress = -1;
    int ncols;
    String desc;
    boolean gui;
    long printIntervalInMilli = 1000L;
    Iterator<T> data;
    long lastPrintTime = 0L;
    long lastProgress;
    long beginTime;
    char unitChar = (char)9608;
    char[] chars;
    GuiProgress guiProgress;
    static final int DEFAULT_NCOLS = 70;

    public static <T> Tqdm<T> tqdm(List<T> a) {
        return new Tqdm<T>(a.iterator(), a.size(), "", 70, false);
    }

    public static Tqdm<Object> tqdm(int total, String desc) {
        return new Tqdm<Object>(null, total, desc, 70, false);
    }

    public static Tqdm<Object> tqdm(int total, String desc, boolean gui) {
        return new Tqdm<Object>(null, total, desc, 70, gui);
    }

    public static <T> Tqdm<T> tqdm(Iterator<T> a, int total, String desc) {
        return new Tqdm<T>(a, total, desc, 70, false);
    }

    public static <T> Tqdm<T> tqdm(List<T> a, String desc) {
        return new Tqdm<T>(a.iterator(), a.size(), desc, 70, false);
    }

    public static <T> Tqdm<T> tqdm(List<T> a, boolean gui) {
        return new Tqdm<T>(a.iterator(), a.size(), "", 70, gui);
    }

    public static <T> Tqdm<T> tqdm(List<T> a, int width) {
        return new Tqdm<T>(a.iterator(), a.size(), "", 70, false);
    }

    Tqdm(Iterator<T> a, int total, String desc, int ncols, boolean gui) {
        this.total = total;
        this.data = a;
        this.desc = desc;
        this.ncols = ncols == -1 ? 70 : ncols;
        this.beginTime = this.lastPrintTime = System.currentTimeMillis();
        this.chars = new char[ncols];
        this.gui = gui;
        if (gui) {
            this.guiProgress = new GuiProgress();
        }
    }

    public void update(int delta) {
        this.progress += delta;
        if (System.currentTimeMillis() - this.lastPrintTime > this.printIntervalInMilli) {
            String speedString = this.formatSpeed(this.progress, this.lastProgress, System.currentTimeMillis() - this.lastPrintTime);
            double percent = 1.0 * (double)this.progress / (double)this.total * 100.0;
            String percentString = String.format("%2d%%", (int)percent);
            long usedTime = System.currentTimeMillis() - this.beginTime;
            long leftTime = (long)((double)usedTime * 1.0 / (double)this.progress * (double)(this.total - this.progress));
            String timeString = String.format("[%s<%s,%s]", this.formatTime(usedTime), this.formatTime(leftTime), speedString);
            if (this.gui) {
                this.guiProgress.progress.setValue(this.progress);
                this.guiProgress.label.setText(String.format("%s %d/%d %s", percentString, this.progress, this.total, timeString));
                if (this.data != null && !this.data.hasNext() || this.progress >= this.total) {
                    this.guiProgress.complete();
                }
            } else {
                StringBuilder builder = new StringBuilder("\r");
                if (this.desc != null) {
                    builder.append(this.desc).append(':');
                }
                builder.append(percentString);
                int charCount = Math.min(this.progress * this.ncols / this.total, this.chars.length);
                Arrays.fill(this.chars, 0, charCount, this.unitChar);
                Arrays.fill(this.chars, charCount, this.ncols, ' ');
                builder.append('|').append(this.chars).append('|');
                builder.append(String.format("%d/%d", this.progress, this.total));
                builder.append(timeString);
                System.out.print(builder.toString());
            }
            this.lastPrintTime = System.currentTimeMillis();
            this.lastProgress = this.progress;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (Tqdm.this.data == null) {
                    throw new RuntimeException("tqdm need set data");
                }
                return Tqdm.this.data.hasNext();
            }

            @Override
            public T next() {
                Tqdm.this.update(1);
                return Tqdm.this.data.next();
            }
        };
    }

    String formatTime(long duration) {
        int SECOND = 1000;
        int MINUTE = 60000;
        int HOUR = 3600000;
        int DAY = 86400000;
        long day = duration / 86400000L;
        long hour = (duration %= 86400000L) / 3600000L;
        long minute = (duration %= 3600000L) / 60000L;
        long second = (duration %= 60000L) / 1000L;
        StringBuilder builder = new StringBuilder();
        if (day > 0L) {
            builder.append(String.format("%dd", day));
        }
        if (hour > 0L) {
            builder.append(String.format("%dH", hour));
        }
        if (minute > 0L) {
            builder.append(String.format("%dm", minute));
        }
        if (second > 0L) {
            builder.append(String.format("%ds", second));
        }
        return builder.toString();
    }

    String formatSpeed(long currentProgress, long lastProgress, long duration) {
        long progress = currentProgress - lastProgress;
        if (progress == 1L) {
            return String.format("%s/iter", this.formatTime(duration));
        }
        return String.format("%s iter/s", progress);
    }

    class GuiProgress
    extends JFrame {
        JProgressBar progress;
        JLabel label;

        GuiProgress() {
            int width = 500;
            int height = 200;
            this.setSize(width, height);
            this.setTitle(Tqdm.this.desc);
            this.setDefaultCloseOperation(3);
            this.progress = new JProgressBar();
            this.progress.setMaximum(Tqdm.this.total);
            this.label = new JLabel();
            this.label.setBackground(Color.red);
            this.label.setHorizontalTextPosition(0);
            this.label.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 2, 25));
            this.setLayout(new BorderLayout());
            this.setLocationRelativeTo(null);
            this.add((Component)this.progress, "Center");
            this.add((Component)this.label, "South");
            this.setResizable(false);
            this.setVisible(true);
        }

        void complete() {
            this.setVisible(false);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.dispose();
        }
    }
}

