/*
 * Decompiled with CFR 0.152.
 */
package cn.weiguangfu.swagger2.plus.util;

import cn.weiguangfu.swagger2.plus.util.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import springfox.documentation.service.Operation;

public final class ObjectUtil {
    private static Logger logger = LoggerFactory.getLogger(ObjectUtil.class);

    private ObjectUtil() {
    }

    public static void setFieldValue(Operation operation, String fieldName, Object fieldValue) {
        if (Objects.isNull(operation) || StringUtils.isEmpty((Object)fieldName)) {
            return;
        }
        try {
            Class<?> clazz = operation.getClass();
            Field parameters = clazz.getDeclaredField(fieldName);
            parameters.setAccessible(true);
            parameters.set(operation, fieldValue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("ObjectUtil setFieldValue error, fieldName=" + fieldName + ", fieldValue=" + fieldValue + ", error: ", (Throwable)e);
        }
    }

    public static <T extends Annotation> T getFieldAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        if (Objects.isNull(clazz)) {
            return null;
        }
        try {
            Field declaredField = clazz.getDeclaredField(fieldName);
            return declaredField.getAnnotation(annotationClass);
        }
        catch (NoSuchFieldException e) {
            logger.error("ObjectUtil getAnnotation error, clazz=" + clazz + ", fieldName=" + fieldName + ", error: ", (Throwable)e);
            return null;
        }
    }

    public static boolean isSingleEquals(Object[] sourceArray, Object[] targetArray) {
        if (ArrayUtil.isEmpty(sourceArray) || ArrayUtil.isEmpty(targetArray)) {
            return false;
        }
        for (Object sourceObject : sourceArray) {
            for (Object targetObject : targetArray) {
                if (!Objects.equals(sourceObject, targetObject)) continue;
                return true;
            }
        }
        return false;
    }
}

