/*
 * Decompiled with CFR 0.152.
 */
package cn.weiguangfu.swagger2.plus.filter;

import cn.weiguangfu.swagger2.plus.annotation.ApiGroup;
import cn.weiguangfu.swagger2.plus.annotation.ApiRequestExclude;
import cn.weiguangfu.swagger2.plus.annotation.ApiRequestInclude;
import cn.weiguangfu.swagger2.plus.annotation.ApiResponseExclude;
import cn.weiguangfu.swagger2.plus.annotation.ApiResponseInclude;
import cn.weiguangfu.swagger2.plus.enums.ApiExecutionEnum;
import cn.weiguangfu.swagger2.plus.enums.ApiModelTypeEnum;
import cn.weiguangfu.swagger2.plus.filter.FilterField;
import cn.weiguangfu.swagger2.plus.util.ObjectUtil;
import java.util.Objects;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
public class GroupFilterField
implements FilterField {
    @Override
    public boolean isFilterField(RequestMappingContext requestMappingContext, ApiModelTypeEnum apiModelTypeEnum, Class<?> erasedTypeClass, String fieldName) {
        if (!requestMappingContext.findAnnotation(ApiGroup.class).isPresent()) {
            return false;
        }
        ApiGroup apiGroup = (ApiGroup)requestMappingContext.findAnnotation(ApiGroup.class).get();
        Object[] apiGroups = apiGroup.groups();
        if (Objects.equals((Object)apiModelTypeEnum, (Object)ApiModelTypeEnum.REQUEST) && Objects.equals((Object)apiGroup.requestExecution(), (Object)ApiExecutionEnum.INCLUDE)) {
            ApiRequestInclude apiRequestInclude = ObjectUtil.getFieldAnnotation(erasedTypeClass, fieldName, ApiRequestInclude.class);
            return Objects.isNull(apiRequestInclude) || !ObjectUtil.isSingleEquals(apiRequestInclude.groups(), apiGroups);
        }
        if (Objects.equals((Object)apiModelTypeEnum, (Object)ApiModelTypeEnum.REQUEST) && Objects.equals((Object)apiGroup.requestExecution(), (Object)ApiExecutionEnum.EXCLUDE)) {
            ApiRequestExclude apiRequestExclude = ObjectUtil.getFieldAnnotation(erasedTypeClass, fieldName, ApiRequestExclude.class);
            return Objects.nonNull(apiRequestExclude) && ObjectUtil.isSingleEquals(apiRequestExclude.groups(), apiGroups);
        }
        if (Objects.equals((Object)apiModelTypeEnum, (Object)ApiModelTypeEnum.RESPONSE) && Objects.equals((Object)apiGroup.responseExecution(), (Object)ApiExecutionEnum.INCLUDE)) {
            ApiResponseInclude apiResponseInclude = ObjectUtil.getFieldAnnotation(erasedTypeClass, fieldName, ApiResponseInclude.class);
            return Objects.isNull(apiResponseInclude) || !ObjectUtil.isSingleEquals(apiResponseInclude.groups(), apiGroups);
        }
        if (Objects.equals((Object)apiModelTypeEnum, (Object)ApiModelTypeEnum.RESPONSE) && Objects.equals((Object)apiGroup.responseExecution(), (Object)ApiExecutionEnum.EXCLUDE)) {
            ApiResponseExclude apiResponseExclude = ObjectUtil.getFieldAnnotation(erasedTypeClass, fieldName, ApiResponseExclude.class);
            return Objects.nonNull(apiResponseExclude) && ObjectUtil.isSingleEquals(apiResponseExclude.groups(), apiGroups);
        }
        return false;
    }
}

