/*
 * Decompiled with CFR 0.152.
 */
package cn.weiguangfu.swagger2.plus.extension;

import cn.weiguangfu.swagger2.plus.plus.DefaultSwagger2Push;
import cn.weiguangfu.swagger2.plus.plus.Swagger2Push;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.paths.PathMappingAdjuster;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDescriptionReader;
import springfox.documentation.spring.web.scanners.ApiListingScanner;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;
import springfox.documentation.spring.web.scanners.ApiModelReader;

@Primary
@Import(value={DefaultSwagger2Push.class})
public class ApiListingScannerCustom
extends ApiListingScanner {
    @Autowired
    private Swagger2Push swagger2Push;
    private final ApiDescriptionReader apiDescriptionReader;
    private final ApiModelReader apiModelReader;
    private final DocumentationPluginsManager pluginsManager;

    @Autowired
    public ApiListingScannerCustom(ApiDescriptionReader apiDescriptionReader, ApiModelReader apiModelReader, DocumentationPluginsManager pluginsManager) {
        super(apiDescriptionReader, apiModelReader, pluginsManager);
        this.apiDescriptionReader = apiDescriptionReader;
        this.apiModelReader = apiModelReader;
        this.pluginsManager = pluginsManager;
    }

    public Multimap<String, ApiListing> scan(ApiListingScanningContext context) {
        LinkedListMultimap apiListingMap = LinkedListMultimap.create();
        int position = 0;
        Map requestMappingsByResourceGroup = context.getRequestMappingsByResourceGroup();
        ArrayList securityReferences = Lists.newArrayList();
        for (ResourceGroup resourceGroup : this.sortedByName(requestMappingsByResourceGroup.keySet())) {
            DocumentationContext documentationContext = context.getDocumentationContext();
            LinkedHashSet produces = new LinkedHashSet(documentationContext.getProduces());
            LinkedHashSet consumes = new LinkedHashSet(documentationContext.getConsumes());
            String host = documentationContext.getHost();
            LinkedHashSet protocols = new LinkedHashSet(documentationContext.getProtocols());
            HashSet apiDescriptions = Sets.newHashSet();
            LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
            for (RequestMappingContext each : this.sortedByMethods((List)requestMappingsByResourceGroup.get(resourceGroup))) {
                Map modelMap = this.apiModelReader.read(each.withKnownModels(models));
                models.putAll(modelMap);
                List apiDescriptionList = this.apiDescriptionReader.read(each);
                apiDescriptions.addAll(this.swagger2Push.getNewApiDescriptionList(resourceGroup, each, models, apiDescriptionList));
            }
            apiDescriptions.addAll(FluentIterable.from((Iterable)this.pluginsManager.additionalListings(context)).filter(this.onlySelectedApis(documentationContext)).toList());
            ArrayList sortedApis = Lists.newArrayList((Iterable)apiDescriptions);
            Collections.sort(sortedApis, documentationContext.getApiDescriptionOrdering());
            String resourcePath = ApiListingScannerCustom.longestCommonPath(sortedApis);
            PathProvider pathProvider = documentationContext.getPathProvider();
            String basePath = pathProvider.getApplicationBasePath();
            PathMappingAdjuster adjuster = new PathMappingAdjuster(documentationContext);
            ApiListingBuilder apiListingBuilder = new ApiListingBuilder(context.apiDescriptionOrdering()).apiVersion(documentationContext.getApiInfo().getVersion()).basePath(adjuster.adjustedPath(basePath)).resourcePath(resourcePath).produces(produces).consumes(consumes).host(host).protocols(protocols).securityReferences((List)securityReferences).apis((List)sortedApis).models(models).position(position++).availableTags(documentationContext.getTags());
            ApiListingContext apiListingContext = new ApiListingContext(context.getDocumentationType(), resourceGroup, apiListingBuilder);
            apiListingMap.put((Object)resourceGroup.getGroupName(), (Object)this.pluginsManager.apiListing(apiListingContext));
        }
        return apiListingMap;
    }

    private Predicate<ApiDescription> onlySelectedApis(final DocumentationContext context) {
        return new Predicate<ApiDescription>(){

            public boolean apply(ApiDescription input) {
                return context.getApiSelector().getPathSelector().apply((Object)input.getPath());
            }
        };
    }

    private Iterable<ResourceGroup> sortedByName(Set<ResourceGroup> resourceGroups) {
        return FluentIterable.from(resourceGroups).toSortedList(Orderings.resourceGroupComparator());
    }

    private Iterable<RequestMappingContext> sortedByMethods(List<RequestMappingContext> contexts) {
        return FluentIterable.from(contexts).toSortedList(Orderings.methodComparator());
    }

    static String longestCommonPath(List<ApiDescription> apiDescriptions) {
        ArrayList commons = Lists.newArrayList();
        if (null == apiDescriptions || apiDescriptions.isEmpty()) {
            return null;
        }
        List<String> firstWords = ApiListingScannerCustom.urlParts(apiDescriptions.get(0));
        for (int position = 0; position < firstWords.size(); ++position) {
            String word = firstWords.get(position);
            boolean allContain = true;
            for (int i = 1; i < apiDescriptions.size(); ++i) {
                List<String> words = ApiListingScannerCustom.urlParts(apiDescriptions.get(i));
                if (words.size() >= position + 1 && words.get(position).equals(word)) continue;
                allContain = false;
                break;
            }
            if (!allContain) continue;
            commons.add(word);
        }
        Joiner joiner = Joiner.on((String)"/").skipNulls();
        return "/" + joiner.join((Iterable)commons);
    }

    static List<String> urlParts(ApiDescription apiDescription) {
        return Splitter.on((char)'/').omitEmptyStrings().trimResults().splitToList((CharSequence)apiDescription.getPath());
    }
}

