/*
 * Decompiled with CFR 0.152.
 */
package cn.weiguangfu.swagger2.plus.util;

import cn.weiguangfu.swagger2.plus.util.ArrayUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class ObjectUtil {
    private static Logger logger = LoggerFactory.getLogger(ObjectUtil.class);

    private ObjectUtil() {
    }

    public static void setFieldValue(Object object, String fieldName, Object fieldValue) {
        if (Objects.isNull(object) || StringUtils.isEmpty((Object)fieldName)) {
            return;
        }
        Class<?> suppclass = object.getClass();
        block2: do {
            try {
                Object[] parameterList = suppclass.getDeclaredFields();
                if (!ArrayUtil.isNotEmpty(parameterList)) continue;
                for (Object parameter : parameterList) {
                    if (!Objects.equals(fieldName, ((Field)parameter).getName())) continue;
                    ((Field)parameter).setAccessible(true);
                    ((Field)parameter).set(object, fieldValue);
                    continue block2;
                }
            }
            catch (IllegalAccessException e) {
                logger.debug("ObjectUtil setFieldValue error, fieldName=" + fieldName + ", fieldValue=" + fieldValue + ", error: " + e.getMessage());
            }
        } while (Objects.nonNull(suppclass = suppclass.getSuperclass()));
    }

    public static <T extends Annotation> T getFieldAnnotation(Class<?> clazz, String fieldName, Class<T> annotationClass) {
        if (Objects.isNull(clazz)) {
            return null;
        }
        do {
            Object[] parameterList;
            if (!ArrayUtil.isNotEmpty(parameterList = clazz.getDeclaredFields())) continue;
            for (Object parameter : parameterList) {
                if (!Objects.equals(fieldName, ((Field)parameter).getName())) continue;
                return ((Field)parameter).getAnnotation(annotationClass);
            }
        } while (Objects.nonNull(clazz = clazz.getSuperclass()));
        return null;
    }

    public static boolean isSingleEquals(Object[] sourceArray, Object[] targetArray) {
        if (ArrayUtil.isEmpty(sourceArray) || ArrayUtil.isEmpty(targetArray)) {
            return false;
        }
        for (Object sourceObject : sourceArray) {
            for (Object targetObject : targetArray) {
                if (!Objects.equals(sourceObject, targetObject)) continue;
                return true;
            }
        }
        return false;
    }
}

