/*
 * Decompiled with CFR 0.152.
 */
package cn.weiguangfu.swagger2.plus.plus;

import cn.weiguangfu.swagger2.plus.annotation.ApiGroup;
import cn.weiguangfu.swagger2.plus.annotation.ApiPlus;
import cn.weiguangfu.swagger2.plus.enums.ApiModelTypeEnum;
import cn.weiguangfu.swagger2.plus.enums.ResponseStatusEnum;
import cn.weiguangfu.swagger2.plus.factory.ModelFactory;
import cn.weiguangfu.swagger2.plus.factory.ModelPropertyFactory;
import cn.weiguangfu.swagger2.plus.factory.ModelRefFactory;
import cn.weiguangfu.swagger2.plus.factory.OperationFactory;
import cn.weiguangfu.swagger2.plus.filter.FilterField;
import cn.weiguangfu.swagger2.plus.filter.GroupFilterField;
import cn.weiguangfu.swagger2.plus.model.manager.CompletePathModelNameManager;
import cn.weiguangfu.swagger2.plus.model.manager.ModelNameManager;
import cn.weiguangfu.swagger2.plus.plus.Swagger2Push;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
@Import(value={GroupFilterField.class, CompletePathModelNameManager.class})
public class DefaultSwagger2Push
implements Swagger2Push {
    @Autowired
    private FilterField filterField;
    @Autowired
    private ModelNameManager modelNameManager;
    @Value(value="${swagger.push.enable:false}")
    private boolean enable;

    @Override
    public List<ApiDescription> getNewApiDescriptionList(ResourceGroup resourceGroup, RequestMappingContext requestMappingContext, Map<String, Model> models, List<ApiDescription> apiDescriptionList) {
        if (!this.enable || CollectionUtils.isEmpty(apiDescriptionList) || !this.isPlus(resourceGroup)) {
            return apiDescriptionList;
        }
        if (!requestMappingContext.findAnnotation(ApiGroup.class).isPresent()) {
            return apiDescriptionList;
        }
        EnhanceParameter enhanceParameter = new EnhanceParameter(requestMappingContext, models);
        for (ApiDescription apiDescription : apiDescriptionList) {
            List operationList = apiDescription.getOperations();
            if (CollectionUtils.isEmpty((Collection)operationList)) continue;
            enhanceParameter.setPath(apiDescription.getPath());
            for (Operation operation : operationList) {
                enhanceParameter.setUniqueid(operation.getUniqueId());
                this.enhanceOperation(enhanceParameter, operation);
            }
        }
        return apiDescriptionList;
    }

    private boolean isPlus(ResourceGroup resourceGroup) {
        Class controllerClass;
        ApiPlus apiPlus;
        if (Objects.isNull(resourceGroup)) {
            return false;
        }
        if (resourceGroup.getControllerClass().isPresent() && Objects.nonNull(apiPlus = (controllerClass = (Class)resourceGroup.getControllerClass().get()).getAnnotation(ApiPlus.class))) {
            return apiPlus.value();
        }
        return false;
    }

    private Operation enhanceOperation(EnhanceParameter enhanceParameter, Operation operation) {
        OperationFactory operationFactory = OperationFactory.getOperationFactory(operation);
        List parameterList = operation.getParameters();
        if (!CollectionUtils.isEmpty((Collection)parameterList)) {
            ArrayList<Parameter> newParameterList = new ArrayList<Parameter>(parameterList.size());
            for (Parameter parameter : parameterList) {
                newParameterList.add(this.enhanceParameter(enhanceParameter, parameter));
            }
            operationFactory.setParameters(newParameterList);
        }
        ModelReference responseModel = this.enhanceModelReference(enhanceParameter, ApiModelTypeEnum.RESPONSE, operation.getResponseModel());
        operationFactory.setResponseModel(responseModel);
        operationFactory.setResponseMessages(this.enhanceResponseMessage(operation.getResponseMessages(), responseModel));
        return operationFactory.getOperation();
    }

    private Parameter enhanceParameter(EnhanceParameter enhanceParameter, Parameter parameter) {
        return new Parameter(parameter.getName(), parameter.getDescription(), parameter.getDefaultValue(), parameter.isRequired().booleanValue(), parameter.isAllowMultiple().booleanValue(), parameter.isAllowEmptyValue(), this.enhanceModelReference(enhanceParameter, ApiModelTypeEnum.REQUEST, parameter.getModelRef()), parameter.getType(), parameter.getAllowableValues(), parameter.getParamType(), parameter.getParamAccess(), parameter.isHidden().booleanValue(), parameter.getPattern(), parameter.getCollectionFormat(), parameter.getOrder(), parameter.getScalarExample(), parameter.getExamples(), parameter.getVendorExtentions());
    }

    private Set<ResponseMessage> enhanceResponseMessage(Set<ResponseMessage> responseMessageSet, ModelReference responseModel) {
        if (CollectionUtils.isEmpty(responseMessageSet)) {
            return new HashSet<ResponseMessage>();
        }
        HashSet<ResponseMessage> newResponseMessageSet = new HashSet<ResponseMessage>(responseMessageSet.size());
        int okStatus = ResponseStatusEnum.OK.getStatus();
        for (ResponseMessage responseMessage : responseMessageSet) {
            if (Objects.equals(okStatus, responseMessage.getCode())) {
                responseMessage = new ResponseMessage(responseMessage.getCode(), responseMessage.getMessage(), responseModel, responseMessage.getHeaders(), responseMessage.getVendorExtensions());
            }
            newResponseMessageSet.add(responseMessage);
        }
        return newResponseMessageSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelReference enhanceModelReference(EnhanceParameter enhanceParameter, ApiModelTypeEnum modelTypeEnum, ModelReference modelReference) {
        try {
            enhanceParameter.setModelType(modelTypeEnum);
            Optional<ModelReference> newModelReferenceOptional = this.getNewModelReference(enhanceParameter, modelReference);
            if (newModelReferenceOptional.isPresent()) {
                ModelReference modelReference2 = (ModelReference)newModelReferenceOptional.get();
                return modelReference2;
            }
        }
        finally {
            enhanceParameter.removeModelType();
        }
        return modelReference;
    }

    private Optional<Model> getAndCreaeMtodel(EnhanceParameter enhanceParameter, String type) {
        ApiModelTypeEnum modelType;
        String uniqueid;
        String path;
        String newDefinitionsKey;
        Map<String, Model> models = enhanceParameter.getModels();
        Model newDefinitionsModel = models.get(newDefinitionsKey = this.modelNameManager.getModelPlusName(path = enhanceParameter.getPath(), uniqueid = enhanceParameter.getUniqueid(), modelType = enhanceParameter.getModelType(), type));
        if (Objects.isNull(newDefinitionsModel)) {
            Model oldModel = models.get(type);
            if (Objects.isNull(oldModel)) {
                return Optional.absent();
            }
            return this.createModel(enhanceParameter, oldModel, newDefinitionsKey);
        }
        return Optional.of((Object)newDefinitionsModel);
    }

    private Optional<Model> createModel(EnhanceParameter enhanceParameter, Model oldModel, String newDefinitionsKey) {
        Map<String, Model> models = enhanceParameter.getModels();
        Optional<Model> newModelOptional = ModelFactory.newInstance(oldModel, newDefinitionsKey, newDefinitionsKey);
        if (newModelOptional.isPresent()) {
            models.put(newDefinitionsKey, (Model)newModelOptional.get());
        }
        ConcurrentHashMap<String, ModelProperty> newPropertieMap = new ConcurrentHashMap<String, ModelProperty>();
        Map oldPropertieMap = oldModel.getProperties();
        if (!CollectionUtils.isEmpty((Map)oldPropertieMap)) {
            Class erasedTypeClass = oldModel.getType().getErasedType();
            for (Map.Entry oldModelPropertyEntry : oldPropertieMap.entrySet()) {
                if (this.filterField.isFilterField(enhanceParameter.getRequestMappingContext(), enhanceParameter.getModelType(), erasedTypeClass, (String)oldModelPropertyEntry.getKey())) continue;
                ModelProperty newModelProperty = this.getNewModelProperty(enhanceParameter, (ModelProperty)oldModelPropertyEntry.getValue());
                newPropertieMap.put((String)oldModelPropertyEntry.getKey(), newModelProperty);
            }
            newModelOptional = ModelFactory.newInstance(oldModel, newDefinitionsKey, newDefinitionsKey, newPropertieMap);
            if (newModelOptional.isPresent()) {
                models.put(newDefinitionsKey, (Model)newModelOptional.get());
            }
        }
        return newModelOptional;
    }

    private ModelProperty getNewModelProperty(EnhanceParameter enhanceParameter, ModelProperty oldModelProperty) {
        ModelProperty newModelProperty = oldModelProperty;
        Optional<ModelProperty> newModelPropertyOptional = ModelPropertyFactory.newInstance(oldModelProperty);
        if (newModelPropertyOptional.isPresent()) {
            newModelProperty = (ModelProperty)newModelPropertyOptional.get();
            Optional<ModelReference> newModelReferenceOptional = this.getNewModelReference(enhanceParameter, oldModelProperty.getModelRef());
            if (newModelReferenceOptional.isPresent()) {
                newModelProperty.updateModelRef(input -> (ModelReference)newModelReferenceOptional.get());
            }
        }
        return newModelProperty;
    }

    private Optional<ModelReference> getNewModelReference(EnhanceParameter enhanceParameter, ModelReference modelReference) {
        if (Objects.isNull(modelReference)) {
            return Optional.absent();
        }
        if (modelReference.itemModel().isPresent()) {
            ModelReference specialItemModelReference = (ModelReference)modelReference.itemModel().get();
            Optional<ModelReference> finalSpecialItemModelOptional = this.getSpecialItemModel(enhanceParameter, specialItemModelReference);
            if (finalSpecialItemModelOptional.isPresent()) {
                return ModelRefFactory.newInstance(modelReference, (ModelReference)finalSpecialItemModelOptional.get());
            }
        } else {
            String type = modelReference.getType();
            Optional<Model> modelOptional = this.getAndCreaeMtodel(enhanceParameter, type);
            if (modelOptional.isPresent()) {
                return ModelRefFactory.newInstance(modelReference, ((Model)modelOptional.get()).getId());
            }
        }
        return Optional.of((Object)modelReference);
    }

    private Optional<ModelReference> getSpecialItemModel(EnhanceParameter enhanceParameter, ModelReference specialItemModelReference) {
        Optional modelReferenceOptional;
        ModelReference newModelReference = specialItemModelReference;
        Optional<ModelReference> newModelReferenceOptional = ModelRefFactory.newInstance(specialItemModelReference);
        if (newModelReferenceOptional.isPresent()) {
            newModelReference = (ModelReference)newModelReferenceOptional.get();
        }
        if ((modelReferenceOptional = specialItemModelReference.itemModel()).isPresent()) {
            Optional<ModelReference> newNextModelReferenceOptional;
            Optional<ModelReference> nextSpecialItemModelOptional = this.getSpecialItemModel(enhanceParameter, (ModelReference)modelReferenceOptional.get());
            if (nextSpecialItemModelOptional.isPresent() && (newNextModelReferenceOptional = ModelRefFactory.newInstance(newModelReference, (ModelReference)nextSpecialItemModelOptional.get())).isPresent()) {
                newModelReference = (ModelReference)newNextModelReferenceOptional.get();
            }
        } else {
            Optional<ModelReference> newNextModelReferenceOptional;
            Optional<Model> modelOptional = this.getAndCreaeMtodel(enhanceParameter, specialItemModelReference.getType());
            if (modelOptional.isPresent() && (newNextModelReferenceOptional = ModelRefFactory.newInstance(newModelReference, ((Model)modelOptional.get()).getId())).isPresent()) {
                newModelReference = (ModelReference)newNextModelReferenceOptional.get();
            }
        }
        return Optional.of((Object)newModelReference);
    }

    private class EnhanceParameter {
        private String path;
        private String uniqueid;
        private ApiModelTypeEnum modelType;
        private RequestMappingContext requestMappingContext;
        private Map<String, Model> models;

        EnhanceParameter(RequestMappingContext requestMappingContext, Map<String, Model> models) {
            this.requestMappingContext = requestMappingContext;
            this.models = models;
        }

        String getPath() {
            return this.path;
        }

        void setPath(String path) {
            this.path = path;
        }

        public String getUniqueid() {
            return this.uniqueid;
        }

        public void setUniqueid(String uniqueid) {
            this.uniqueid = uniqueid;
        }

        ApiModelTypeEnum getModelType() {
            return this.modelType;
        }

        void setModelType(ApiModelTypeEnum modelType) {
            this.modelType = modelType;
        }

        void removeModelType() {
            this.modelType = null;
        }

        RequestMappingContext getRequestMappingContext() {
            return this.requestMappingContext;
        }

        Map<String, Model> getModels() {
            return this.models;
        }
    }
}

