/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.config;

import cn.echo.sharding.config.AbstractDatabaseConfigSupport;
import cn.echo.sharding.database.DefaultDataSource;
import cn.echo.sharding.database.MasterSlaveRuleConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.TableRuleConfiguration;
import org.apache.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory;

public class DatabaseShardingConfigurator
extends AbstractDatabaseConfigSupport {
    @Override
    public DataSource dataSource(DefaultDataSource defaultDataSource) throws SQLException {
        log.info("Initialize sharding dataSource");
        ShardingRuleConfiguration shardingRuleConfig = new ShardingRuleConfiguration();
        shardingRuleConfig.setTableRuleConfigs(this.tableRuleConfigs());
        shardingRuleConfig.setEncryptRuleConfig(this.encryptRuleConfig());
        shardingRuleConfig.setBindingTableGroups(this.bindingTableGroups());
        shardingRuleConfig.setBroadcastTables(this.broadcastTables());
        shardingRuleConfig.setDefaultDataSourceName(defaultDataSource.getDefaultDataSourceName());
        LinkedList<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();
        for (MasterSlaveRuleConfig config : defaultDataSource.getMasterSlaveRules()) {
            masterSlaveRuleConfigs.add(config.parseMasterSlaveRule());
        }
        shardingRuleConfig.setMasterSlaveRuleConfigs(masterSlaveRuleConfigs);
        HashMap<String, HikariDataSource> dataSourceMap = new HashMap<String, HikariDataSource>();
        dataSourceMap.putAll(defaultDataSource.getDataSources());
        return ShardingDataSourceFactory.createDataSource(dataSourceMap, (ShardingRuleConfiguration)shardingRuleConfig, (Properties)new Properties());
    }

    public Collection<TableRuleConfiguration> tableRuleConfigs() {
        return Collections.emptyList();
    }

    public EncryptRuleConfiguration encryptRuleConfig() {
        return null;
    }

    public Collection<String> broadcastTables() {
        return Collections.emptyList();
    }

    public Collection<String> bindingTableGroups() {
        return Collections.emptyList();
    }
}

