/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.config;

import cn.echo.sharding.aspectj.HintMasterRouteAspect;
import cn.echo.sharding.database.DefaultDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractDatabaseConfigSupport {
    protected static final Logger log = LoggerFactory.getLogger(AbstractDatabaseConfigSupport.class);

    @Bean(name={"defaultDataSource"})
    @ConfigurationProperties(prefix="sharding.jdbc")
    public DefaultDataSource defaultDataSource() {
        return new DefaultDataSource();
    }

    @Primary
    @Bean(name={"dataSource"})
    @ConditionalOnBean(name={"defaultDataSource"})
    public abstract DataSource dataSource(@Qualifier(value="defaultDataSource") DefaultDataSource var1) throws SQLException;

    @Bean
    public PlatformTransactionManager transactionManager(@Qualifier(value="dataSource") DataSource dataSource) {
        DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(dataSource);
        return platformTransactionManager;
    }

    @Bean
    public HintMasterRouteAspect hintMasterRouteAspect() {
        return new HintMasterRouteAspect();
    }
}

