/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.algorithm;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;

public class TendaysPreciseShardingAlgorithm
implements PreciseShardingAlgorithm<Date> {
    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Date> shardingValue) {
        String shardfix = this.getShardfix((Date)shardingValue.getValue());
        for (String each : availableTargetNames) {
            if (!each.endsWith(shardfix)) continue;
            return each;
        }
        throw new UnsupportedOperationException();
    }

    private String getShardfix(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String shardfix = "" + calendar.get(1) + (calendar.get(2) + 1);
        int day = calendar.get(5);
        shardfix = day <= 10 ? shardfix + "01" : (day <= 20 ? shardfix + "02" : shardfix + "03");
        return shardfix;
    }
}

