/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.algorithm;

import com.google.common.collect.Range;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingValue;

public class MonthRangeShardingAlgorithm
implements RangeShardingAlgorithm<Date> {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");

    public Collection<String> doSharding(Collection<String> collection, RangeShardingValue<Date> rangeShardingValue) {
        HashSet<String> collect = new HashSet<String>();
        Range valueRange = rangeShardingValue.getValueRange();
        Date startTime = (Date)valueRange.lowerEndpoint();
        Date endTime = (Date)valueRange.upperEndpoint();
        Calendar calendar = Calendar.getInstance();
        while (startTime.getTime() <= endTime.getTime()) {
            String shardfix = formatter.format(startTime);
            for (String each : collection) {
                if (!each.endsWith(shardfix)) continue;
                collect.add(each);
            }
            calendar.setTime(startTime);
            calendar.add(5, 1);
            startTime = calendar.getTime();
        }
        return collect;
    }
}

