package cn.echo.sharding.database;

import com.zaxxer.hikari.HikariDataSource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 主从模式sharding数据源支持
 * @author lonyee
 */
public class DefaultDataSource {

	private String defaultDataSourceName;
	private Map<String, HikariDataSource> dataSources = new HashMap<String, HikariDataSource>();
    private List<MasterSlaveRuleConfig> masterSlaveRules = new ArrayList<>();
    
	public Map<String, HikariDataSource> getDataSources() {
		return dataSources;
	}
	public void setDataSources(Map<String, HikariDataSource> dataSources) {
		this.dataSources = dataSources;
	}
	public List<MasterSlaveRuleConfig> getMasterSlaveRules() {
		return masterSlaveRules;
	}
	public void setMasterSlaveRules(List<MasterSlaveRuleConfig> masterSlaveRules) {
		this.masterSlaveRules = masterSlaveRules;
	}

	public String getDefaultDataSourceName() {
		return defaultDataSourceName;
	}

	public void setDefaultDataSourceName(String defaultDataSourceName) {
		this.defaultDataSourceName = defaultDataSourceName;
	}
}
