package cn.echo.sharding.config;


import cn.echo.sharding.database.DefaultDataSource;
import cn.echo.sharding.database.MasterSlaveRuleConfig;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.shardingjdbc.api.MasterSlaveDataSourceFactory;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/** 
 * master-slave 数据源配置
 * @author lonyee
 */
public class DatabaseMasterSlaveConfigurator extends AbstractDatabaseConfigSupport {

	 /** 主从数据源配置 */
    public DataSource dataSource(DefaultDataSource defaultDataSource) throws SQLException {
		log.info("Initialize master-slave dataSource");

    	Map<String, DataSource> dataSourceMap = new HashMap<>();
		dataSourceMap.putAll(defaultDataSource.getDataSources());
		//主从库配置 - 主从模式只选第一份数据源配置
		MasterSlaveRuleConfig config = defaultDataSource.getMasterSlaveRules().get(0);
		MasterSlaveRuleConfiguration masterSlaveRuleConfig = new MasterSlaveRuleConfiguration(config.getName(), config.getMasterDataSourceName(), config.getSlaveDataSourceNames());

		return MasterSlaveDataSourceFactory.createDataSource(dataSourceMap, masterSlaveRuleConfig, new Properties());
	}
}
