package cn.echo.sharding.algorithm;

import com.google.common.collect.Range;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingValue;

import java.text.SimpleDateFormat;
import java.util.*;


/**
 * 按月拆表方式
 * @author lonyee
 *
 */
public class MonthRangeShardingAlgorithm implements RangeShardingAlgorithm<Date> {
    private final static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");

    @Override
    public Collection<String> doSharding(Collection<String> collection, RangeShardingValue<Date> rangeShardingValue) {
        Set<String> collect = new HashSet<>();
        Range<Date> valueRange = rangeShardingValue.getValueRange();
        Date startTime = valueRange.lowerEndpoint();
        Date endTime = valueRange.upperEndpoint();
        Calendar calendar = Calendar.getInstance();
        while (startTime.getTime()<=endTime.getTime()){
    		String shardfix = formatter.format(startTime);
            for (String each : collection) {
                if (each.endsWith(shardfix)) {
                    collect.add(each);
                }
            }
            calendar.setTime(startTime);
            calendar.add(Calendar.DATE, 1);
            startTime = calendar.getTime();
        }
        return collect;
    }
    
}
