package cn.echo.sharding.algorithm;

import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;


/**
 * 按月拆表方式
 * @author lonyee
 *
 */
public class MonthPreciseShardingAlgorithm implements PreciseShardingAlgorithm<Date> {
    private final static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");

	@Override
	public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Date> shardingValue) {
		String shardfix = formatter.format(shardingValue.getValue());
        for (String each : availableTargetNames) {	
            if (each.endsWith(shardfix)) {
                return each;
            }
        }
        throw new UnsupportedOperationException();
	}
}
