package cn.echo.sharding.algorithm;

import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;

/**
 * 按历史备份拆表  备份2个月前数据
 * @author lonyee
 *
 */
public class HistoryPreciseShardingAlgorithm  implements PreciseShardingAlgorithm<Date> {
	private final static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");

	@Override
	public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Date> shardingValue) {
		LocalDateTime currDate = LocalDateTime.now();
		LocalDateTime shardingDate = LocalDateTime.ofInstant(shardingValue.getValue().toInstant(), ZoneId.systemDefault());

		long interval = ChronoUnit.MONTHS.between(currDate, shardingDate);
		for (String each : availableTargetNames) {
			//2个月前查记录表，2个月内查原表
			if (interval>=2L) {
	            if (each.endsWith("history")) {
	                return each;
	            }
			} else {
				if (!each.endsWith("history")) {
					return each;
				}
            }
        }
		
        throw new UnsupportedOperationException();
	}
}
