package cn.echo.sharding.algorithm;

import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;


/**
 * 按天拆表方式
 * @author lonyee
 *
 */
public class DailyPreciseShardingAlgorithm implements PreciseShardingAlgorithm<Date> {

    private final static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");

	@Override
	public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Date> shardingValue) {
		String shardfix = formatter.format(shardingValue.getValue());
        for (String each : availableTargetNames) {	
            if (each.endsWith(shardfix)) {
                return each;
            }
        }
        throw new UnsupportedOperationException();
	}
}
