/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.database;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import org.apache.shardingsphere.api.config.RuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.LoadBalanceStrategyConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;

public final class MasterSlaveRuleConfig
implements RuleConfiguration {
    private String name;
    private String masterDataSourceName;
    private Collection<String> slaveDataSourceNames;
    private String loadBalanceStrategy;

    public MasterSlaveRuleConfig() {
    }

    public MasterSlaveRuleConfig(String name, String masterDataSourceName, Collection<String> slaveDataSourceNames) {
        this(name, masterDataSourceName, slaveDataSourceNames, null);
    }

    public MasterSlaveRuleConfig(String name, String masterDataSourceName, Collection<String> slaveDataSourceNames, String loadBalanceStrategy) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name is required.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)masterDataSourceName) ? 1 : 0) != 0, (Object)"MasterDataSourceName is required.");
        Preconditions.checkArgument((null != slaveDataSourceNames && !slaveDataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"SlaveDataSourceNames is required.");
        this.name = name;
        this.masterDataSourceName = masterDataSourceName;
        this.slaveDataSourceNames = slaveDataSourceNames;
        this.loadBalanceStrategy = loadBalanceStrategy;
    }

    public MasterSlaveRuleConfiguration parseMasterSlaveRule() {
        MasterSlaveRuleConfiguration config = new MasterSlaveRuleConfiguration(this.name, this.masterDataSourceName, this.slaveDataSourceNames, new LoadBalanceStrategyConfiguration(this.loadBalanceStrategy));
        return config;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMasterDataSourceName(String masterDataSourceName) {
        this.masterDataSourceName = masterDataSourceName;
    }

    public void setSlaveDataSourceNames(Collection<String> slaveDataSourceNames) {
        this.slaveDataSourceNames = slaveDataSourceNames;
    }

    public void setLoadBalanceStrategy(String loadBalanceStrategy) {
        this.loadBalanceStrategy = loadBalanceStrategy;
    }

    public String getName() {
        return this.name;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public Collection<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    public String getLoadBalanceStrategy() {
        return this.loadBalanceStrategy;
    }
}

