/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.config;

import cn.echo.sharding.config.AbstractDatabaseConfigSupport;
import cn.echo.sharding.database.DefaultDataSource;
import cn.echo.sharding.database.MasterSlaveRuleConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.shardingjdbc.api.MasterSlaveDataSourceFactory;

public class DatabaseMasterSlaveConfigurator
extends AbstractDatabaseConfigSupport {
    @Override
    public DataSource dataSource(DefaultDataSource defaultDataSource) throws SQLException {
        log.info("Initialize master-slave dataSource");
        HashMap<String, HikariDataSource> dataSourceMap = new HashMap<String, HikariDataSource>();
        dataSourceMap.putAll(defaultDataSource.getDataSources());
        MasterSlaveRuleConfig config = defaultDataSource.getMasterSlaveRules().get(0);
        MasterSlaveRuleConfiguration masterSlaveRuleConfig = new MasterSlaveRuleConfiguration(config.getName(), config.getMasterDataSourceName(), config.getSlaveDataSourceNames());
        return MasterSlaveDataSourceFactory.createDataSource(dataSourceMap, (MasterSlaveRuleConfiguration)masterSlaveRuleConfig, (Properties)new Properties());
    }
}

