/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.aspectj;

import cn.echo.sharding.annotation.HintMasterRoute;
import cn.echo.sharding.aspectj.AbstractShardingAspectSupport;
import java.lang.reflect.Method;
import org.apache.shardingsphere.api.hint.HintManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class HintMasterRouteAspect
extends AbstractShardingAspectSupport {
    @Pointcut(value="@annotation(HintMasterRoute)")
    public void masterRouteAnnotationPointcut() {
    }

    @Around(value="masterRouteAnnotationPointcut()")
    public Object invokeMasterRoute(ProceedingJoinPoint pjp) throws Throwable {
        Method originMethod = this.resolveMethod(pjp);
        HintMasterRoute annotation = originMethod.getAnnotation(HintMasterRoute.class);
        if (annotation == null) {
            throw new IllegalStateException("Wrong state for HintMasterRoute annotation");
        }
        if (!annotation.isMasterOnly()) {
            return pjp.proceed();
        }
        this.log.info("hint route master datasource.");
        HintManager.clear();
        try (HintManager hintManager = HintManager.getInstance();){
            hintManager.setMasterRouteOnly();
            Object object = pjp.proceed();
            return object;
        }
    }
}

