/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.algorithm;

import com.google.common.collect.Range;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingValue;

public class TendaysRangeShardingAlgorithm
implements RangeShardingAlgorithm<Date> {
    public Collection<String> doSharding(Collection<String> collection, RangeShardingValue<Date> rangeShardingValue) {
        HashSet<String> collect = new HashSet<String>();
        Range valueRange = rangeShardingValue.getValueRange();
        Date startTime = (Date)valueRange.lowerEndpoint();
        Date endTime = (Date)valueRange.upperEndpoint();
        Calendar calendar = Calendar.getInstance();
        while (startTime.getTime() <= endTime.getTime()) {
            String shardfix = this.getShardfix(startTime);
            for (String each : collection) {
                if (!each.endsWith(shardfix)) continue;
                collect.add(each);
            }
            calendar.setTime(startTime);
            calendar.add(5, 1);
            startTime = calendar.getTime();
        }
        return collect;
    }

    private String getShardfix(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String shardfix = "" + calendar.get(1) + (calendar.get(2) + 1);
        int day = calendar.get(5);
        shardfix = day <= 10 ? shardfix + "_01" : (day <= 20 ? shardfix + "_02" : shardfix + "_03");
        return shardfix;
    }
}

