/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.algorithm;

import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.RangeShardingValue;

public class HistoryRangeShardingAlgorithm
implements RangeShardingAlgorithm<Date> {
    public Collection<String> doSharding(Collection<String> collection, RangeShardingValue<Date> rangeShardingValue) {
        HashSet<String> collect = new HashSet<String>();
        Range valueRange = rangeShardingValue.getValueRange();
        Date startTime = (Date)valueRange.lowerEndpoint();
        Date endTime = (Date)valueRange.upperEndpoint();
        Calendar calendar = Calendar.getInstance();
        LocalDateTime currDate = LocalDateTime.now();
        while (startTime.getTime() <= endTime.getTime()) {
            LocalDateTime shardingDate = LocalDateTime.ofInstant(startTime.toInstant(), ZoneId.systemDefault());
            long interval = ChronoUnit.MONTHS.between(currDate, shardingDate);
            for (String each : collection) {
                if (interval >= 2L) {
                    if (each.endsWith("history")) {
                        collect.add(each);
                    }
                } else if (!each.endsWith("history")) {
                    collect.add(each);
                }
                if (collect.size() < 2) continue;
                return collect;
            }
            calendar.setTime(startTime);
            calendar.add(5, 1);
            startTime = calendar.getTime();
        }
        return collect;
    }
}

