/*
 * Decompiled with CFR 0.152.
 */
package cn.echo.sharding.algorithm;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.standard.PreciseShardingValue;

public class HistoryPreciseShardingAlgorithm
implements PreciseShardingAlgorithm<Date> {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<Date> shardingValue) {
        LocalDateTime currDate = LocalDateTime.now();
        LocalDateTime shardingDate = LocalDateTime.ofInstant(((Date)shardingValue.getValue()).toInstant(), ZoneId.systemDefault());
        long interval = ChronoUnit.MONTHS.between(currDate, shardingDate);
        for (String each : availableTargetNames) {
            if (!(interval >= 2L ? each.endsWith("history") : !each.endsWith("history"))) continue;
            return each;
        }
        throw new UnsupportedOperationException();
    }
}

