package cn.echo.sharding.config;

import cn.echo.sharding.database.DefaultDataSource;
import com.zaxxer.hikari.HikariDataSource;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.Collection;

/**
 * 单库表数据源配置
 * @author lonyee
 */
public class DatabaseSingletonConfigurator extends AbstractDatabaseConfigSupport {

    @Override
    public DataSource dataSource(DefaultDataSource defaultDataSource) throws SQLException {
        log.info("Initialize singleton dataSource");
        Collection<HikariDataSource> dataSources = defaultDataSource.getDataSources().values();

        return dataSources.size()>0? dataSources.iterator().next(): null;
    }
}
