package cn.web3er.wrench.rate.limiter.types.annotations;



import cn.web3er.wrench.rate.limiter.enums.LimitType;

import java.lang.annotation.*;

/**
* @author: Wanghaonan @戏人看戏
* @description: 这个是before拦截
* @create: 2025/8/20 14:23
*/
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface RateLimiter {
    /**
     * 限流key,支持使用Spring el表达式来动态获取方法上的参数值
     * 格式类似于  #code.id #{#code}
     */
    String key() default "";

    /**
     * 限流时间,单位秒
     */
    int time() default 60;

    /**
     * 限流次数
     */
    int count() default 100;

    /**
     * 限流类型
     */
    LimitType limitType() default LimitType.DEFAULT;

    /**
     * 提示消息 支持国际化 格式为 {code}
     */
    String message() default "{rate.limiter.message}";

    /**
     * 限流策略超时时间 默认一天(策略存活时间 会清除已存在的策略数据)
     */
    int timeout() default 86400;

    /** 拦截后的执行方法 */
    String fallbackMethod() default "null";
}
