/*
 * Decompiled with CFR 0.152.
 */
package cn.wearctic.plug;

import java.util.Map;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class PlugInvocationContext {
    private static final ThreadLocal<EvaluationContext> invocationCtx = new ThreadLocal();

    private static EvaluationContext getOrDefault() {
        EvaluationContext ctx = invocationCtx.get();
        if (ctx == null) {
            ctx = new StandardEvaluationContext();
        }
        return ctx;
    }

    public static void register(String variableName, Object obj) {
        EvaluationContext ctx = PlugInvocationContext.getOrDefault();
        ctx.setVariable(variableName, obj);
        invocationCtx.set(ctx);
    }

    public static void register(Map<String, Object> params) {
        EvaluationContext ctx = PlugInvocationContext.getOrDefault();
        params.forEach((arg_0, arg_1) -> ((EvaluationContext)ctx).setVariable(arg_0, arg_1));
        invocationCtx.set(ctx);
    }

    public static Object getVariable(String variableName) {
        return PlugInvocationContext.getVariable(variableName, Object.class);
    }

    public static <E> E getVariable(String variableName, Class<E> clz) {
        EvaluationContext ctx = invocationCtx.get();
        if (ctx == null) {
            return null;
        }
        return (E)ctx.lookupVariable(variableName);
    }

    static EvaluationContext getContext() {
        return invocationCtx.get();
    }

    static void clear() {
        invocationCtx.remove();
    }
}

