/*
 * Decompiled with CFR 0.152.
 */
package cn.wearctic.plug;

import cn.wearctic.plug.Invocation;
import cn.wearctic.plug.PlugContextCustomizer;
import cn.wearctic.plug.context.CompositePlugContext;
import cn.wearctic.plug.context.PlugContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class PlugContextHolder {
    private static final Logger log = LoggerFactory.getLogger(PlugContextHolder.class);
    private static final ConcurrentHashMap<String, List<Invocation>> plugMapInfo = new ConcurrentHashMap();
    private static final ThreadLocal<PlugContext> invocationCtx = new ThreadLocal();
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final List<PlugContextCustomizer> customizers = new ArrayList<PlugContextCustomizer>();

    private static PlugContext getOrDefault() {
        PlugContext ctx = invocationCtx.get();
        if (ctx == null) {
            CompositePlugContext obj = new CompositePlugContext();
            ctx = obj;
            invocationCtx.set(ctx);
            customizers.forEach(it -> it.customizer(obj));
        }
        return ctx;
    }

    public static void register(String variableName, Object obj) {
        PlugContext ctx = PlugContextHolder.getOrDefault();
        ctx.register(variableName, obj);
    }

    public static void register(Map<String, ?> params) {
        PlugContext ctx = PlugContextHolder.getOrDefault();
        ctx.register(params);
    }

    public static void register(String name, Method method) {
        PlugContext ctx = PlugContextHolder.getOrDefault();
        ctx.register(name, method);
    }

    public static Object getVariable(String variableName) {
        return PlugContextHolder.getVariable(variableName, Object.class);
    }

    public static <E> E getVariable(String variableName, Class<E> clz) {
        PlugContext ctx = PlugContextHolder.getOrDefault();
        return ctx.getVariable(variableName, clz);
    }

    public static boolean evaluateBool(String expression) {
        return PlugContextHolder.evaluateExpression(expression, Boolean.class);
    }

    public static <E> E evaluateExpression(String expression, Class<E> clz) {
        CompositePlugContext ctx = (CompositePlugContext)PlugContextHolder.getOrDefault();
        Expression exp = parser.parseExpression(expression);
        return (E)exp.getValue(ctx.getEvaluationContext(), clz);
    }

    public static void invokePlug(String key) {
        PlugContextHolder.invokePlug(key, null);
    }

    public static void invokePlug(String key, Map<String, ?> variables) {
        if (variables != null) {
            PlugContextHolder.register(variables);
        }
        plugMapInfo.getOrDefault(key, Collections.emptyList()).forEach(it -> {
            if (it.getCondition().isEmpty() || PlugContextHolder.evaluateBool(it.getCondition())) {
                try {
                    it.getMethod().invoke(it.getTarget(), new Object[0]);
                }
                catch (InvocationTargetException e) {
                    log.error(e.getMessage());
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    throw new RuntimeException(e.getTargetException());
                }
                catch (IllegalAccessException e) {
                    log.error(e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        });
    }

    static void addPlugMapInfo(String key, List<Invocation> list) {
        List objList = plugMapInfo.getOrDefault(key, new ArrayList());
        objList.addAll(list);
        objList.sort(Comparator.comparingInt(Invocation::getOrder));
        plugMapInfo.put(key, objList);
    }

    static void addCustomizer(PlugContextCustomizer customizer) {
        customizers.add(customizer);
    }

    static void clear() {
        invocationCtx.remove();
    }
}

