/*
 * Decompiled with CFR 0.152.
 */
package cn.wearctic.plug;

import cn.wearctic.plug.Invocation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class PlugInvocationContext {
    private static final Logger log = LoggerFactory.getLogger(PlugInvocationContext.class);
    private static final ConcurrentHashMap<String, List<Invocation>> plugMapInfo = new ConcurrentHashMap();
    private static final ThreadLocal<EvaluationContext> invocationCtx = new ThreadLocal();
    private static final ExpressionParser parser = new SpelExpressionParser();

    private static EvaluationContext getOrDefault() {
        EvaluationContext ctx = invocationCtx.get();
        if (ctx == null) {
            ctx = new StandardEvaluationContext();
        }
        return ctx;
    }

    public static void register(String variableName, Object obj) {
        EvaluationContext ctx = PlugInvocationContext.getOrDefault();
        ctx.setVariable(variableName, obj);
        invocationCtx.set(ctx);
    }

    public static void register(Map<String, ?> params) {
        EvaluationContext ctx = PlugInvocationContext.getOrDefault();
        params.forEach((arg_0, arg_1) -> ((EvaluationContext)ctx).setVariable(arg_0, arg_1));
        invocationCtx.set(ctx);
    }

    public static Object getVariable(String variableName) {
        return PlugInvocationContext.getVariable(variableName, Object.class);
    }

    public static <E> E getVariable(String variableName, Class<E> clz) {
        EvaluationContext ctx = invocationCtx.get();
        if (ctx == null) {
            return null;
        }
        return (E)ctx.lookupVariable(variableName);
    }

    public static boolean evaluateBool(String expression) {
        return PlugInvocationContext.evaluateExpression(expression, Boolean.class);
    }

    public static <E> E evaluateExpression(String expression, Class<E> clz) {
        Expression exp = parser.parseExpression(expression);
        return (E)exp.getValue(PlugInvocationContext.getContext(), clz);
    }

    public static void invokePlug(String key) {
        PlugInvocationContext.invokePlug(key, null);
    }

    public static void invokePlug(String key, Map<String, ?> variables) {
        if (variables != null) {
            PlugInvocationContext.register(variables);
        }
        plugMapInfo.getOrDefault(key, Collections.emptyList()).forEach(it -> {
            if (it.getCondition().isEmpty() || PlugInvocationContext.evaluateBool(it.getCondition())) {
                try {
                    it.getMethod().invoke(it.getTarget(), new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.error(e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        });
    }

    static EvaluationContext getContext() {
        return invocationCtx.get();
    }

    static void addPlugMapInfo(String key, List<Invocation> list) {
        List objList = plugMapInfo.getOrDefault(key, new ArrayList());
        objList.addAll(list);
        objList.sort(Comparator.comparingInt(Invocation::getOrder));
        plugMapInfo.put(key, objList);
    }

    static void clear() {
        invocationCtx.remove();
    }
}

