/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.openapi.aop;

import cn.watsontech.webhelper.common.util.RequestUtils;
import cn.watsontech.webhelper.openapi.aop.annotation.OpenApi;
import cn.watsontech.webhelper.openapi.entity.AppInfo;
import cn.watsontech.webhelper.openapi.params.base.OpenApiParams;
import cn.watsontech.webhelper.openapi.params.base.PublicApiParams;
import cn.watsontech.webhelper.openapi.service.OpenAppInfoService;
import cn.watsontech.webhelper.utils.Md5Util;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OpenApiAspect {
    protected static final Log log = LogFactory.getLog(OpenApiAspect.class);
    @Autowired
    OpenAppInfoService openAppInfoService;
    ThreadLocal<PublicApiParams> publicApiParamThreadLocal = new ThreadLocal();

    @Pointcut(value="@annotation(cn.watsontech.webhelper.openapi.aop.annotation.OpenApi)")
    public void openApi() {
    }

    @Before(value="openApi()")
    public void doBefore(JoinPoint joinPoint) {
        String needSignParamString;
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestUrl = request.getRequestURI();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        OpenApi openApi = methodSignature.getMethod().getAnnotation(OpenApi.class);
        log.info((Object)String.format("OpenApiAspect-%s.doBefore()\uff0c%s, %s", openApi.value(), RequestUtils.getIpAddress((HttpServletRequest)request), requestUrl));
        PublicApiParams apiParams = null;
        ArrayList<OpenApiParams> extraApiParams = new ArrayList<OpenApiParams>();
        Object[] args = joinPoint.getArgs();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof PublicApiParams) {
                    apiParams = (PublicApiParams)args[i];
                }
                if (!(args[i] instanceof OpenApiParams)) continue;
                extraApiParams.add((OpenApiParams)args[i]);
            }
        }
        Assert.notNull(apiParams, (String)"\u975e\u6cd5\u8bf7\u6c42");
        apiParams.setRequestId(RandomStringUtils.randomAlphanumeric((int)12));
        this.publicApiParamThreadLocal.set(apiParams);
        AppInfo openAppinfoVo = this.openAppInfoService.selectByAppId(apiParams.getAppid());
        Assert.notNull((Object)openAppinfoVo, (String)"\u975e\u6cd5\u8bf7\u6c42\uff1a\u672a\u8bc6\u522b\u7684appid");
        String appSecret = openAppinfoVo.getSecret();
        int maximumDelayTime = 30000;
        if (openAppinfoVo.getAllowDelay() != null) {
            maximumDelayTime = openAppinfoVo.getAllowDelay() * 1000;
        }
        Assert.isTrue(((needSignParamString = apiParams.getNeedSignParamString(extraApiParams)) != null && !needSignParamString.equals("") ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u7b7e\u540d\u53c2\u6570\u5217\u8868\u4e3a\u7a7a");
        String signedString = Md5Util.MD5Encode((String)String.format("%s&appSecret=%s&url=%s", needSignParamString, appSecret, requestUrl)).toUpperCase();
        long currentTimestamp = System.currentTimeMillis();
        log.info((Object)String.format("OpenApiAspect.doBefore \u52a0\u5bc6\u5b57\u7b26\u4e32\uff1a%s\uff0c\u5df2\u7b7e\u540d\u5b57\u7b26\u4e32\uff1a%s, \u5f53\u524d\u65f6\u95f4\u6233\uff1a%s", needSignParamString, signedString, currentTimestamp));
        Assert.isTrue((boolean)signedString.equals(apiParams.getSign()), (String)"\u975e\u6cd5\u8bf7\u6c42\uff1a\u7b7e\u540d\u9519\u8bef");
        long timestampGap = currentTimestamp - apiParams.getTimestamp();
        Assert.isTrue((Math.abs(timestampGap) < (long)maximumDelayTime ? 1 : 0) != 0, (String)"\u975e\u6cd5\u8bf7\u6c42\uff1a\u65e0\u6548\u7684\u65f6\u95f4\u6233");
    }

    @After(value="openApi()")
    public void doAfter(JoinPoint joinPoint) {
        PublicApiParams apiParams = this.publicApiParamThreadLocal.get();
        log.info((Object)String.format("OpenApiAspect.doAfter()\uff0c\u8bf7\u6c42ID\uff1a%s", apiParams.getRequestId()));
    }

    @AfterThrowing(value="openApi()", throwing="exception")
    public void doAfterThrowingAdvice(JoinPoint joinPoint, Throwable exception) {
        PublicApiParams apiParams = this.publicApiParamThreadLocal.get();
        log.info((Object)String.format("OpenApiAspect-%s-[\u5f02\u5e38].doAfterThrowingAdvice() - requestId:%s", apiParams.getAppid(), apiParams.getRequestId()));
    }
}

