/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.openapi.error;

import cn.watsontech.webhelper.common.result.Result;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.UnknownHttpStatusCodeException;

public class OpenApiResponseErrorHandler
extends DefaultResponseErrorHandler {
    protected void handleError(ClientHttpResponse response, HttpStatus statusCode) throws IOException {
        Result result;
        String statusText = response.getStatusText();
        HttpHeaders headers = response.getHeaders();
        byte[] body = this.getResponseBody(response);
        Charset charset = this.getCharset(response);
        if (this.isEmpty(body)) {
            result = new Result();
            result.setMessage((Object)"\u672a\u77e5\u9519\u8bef");
        } else {
            result = (Result)new ObjectMapper().readValue(body, Result.class);
        }
        String message = (String)result.getMessage();
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw HttpClientErrorException.create((String)message, (HttpStatus)statusCode, (String)statusText, (HttpHeaders)headers, (byte[])body, (Charset)charset);
            }
            case SERVER_ERROR: {
                throw HttpServerErrorException.create((String)message, (HttpStatus)statusCode, (String)statusText, (HttpHeaders)headers, (byte[])body, (Charset)charset);
            }
        }
        throw new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body, charset);
    }

    private boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    private String getErrorMessage(@Nullable byte[] responseBody, @Nullable Charset charset) {
        if (this.isEmpty(responseBody)) {
            return "";
        }
        charset = charset == null ? StandardCharsets.UTF_8 : charset;
        int maxChars = 200;
        if (responseBody.length < maxChars * 2) {
            return new String(responseBody, charset);
        }
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(responseBody), charset);
            CharBuffer buffer = CharBuffer.allocate(maxChars);
            ((Reader)reader).read(buffer);
            ((Reader)reader).close();
            buffer.flip();
            return buffer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

