/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.openapi.service;

import cn.watsontech.webhelper.common.result.Result;
import cn.watsontech.webhelper.common.vo.WxAuthorizeUserVo;
import cn.watsontech.webhelper.openapi.error.OpenApiResponseErrorHandler;
import cn.watsontech.webhelper.openapi.form.wx.WxMaSubscribeMsgForm;
import cn.watsontech.webhelper.openapi.form.wx.WxMessageData;
import cn.watsontech.webhelper.openapi.form.wx.WxMpSubscribeMsgForm;
import cn.watsontech.webhelper.openapi.params.base.MapOpenApiParams;
import cn.watsontech.webhelper.openapi.params.base.OpenApiParamsVo;
import cn.watsontech.webhelper.utils.Md5Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class OpenApiDecodeService {
    RestTemplate restTemplate;
    String host;
    static final String WXAPP_LOGIN_URL = "/api/open/v1/%s/wxapp/login";
    static final String WXAPP_PARSE_USERINFO_URL = "/api/open/v1/%s/wxapp/parseWxUserInfo";
    static final String WXAPP_SECCHECK_TEXT_URL = "/api/open/v1/%s/secCheck/text";
    static final String WXAPP_SEND_SUBSCRIBE_MESSAGE = "/api/open/v1/%s/wxapp/sendMaSubscribeMsg";
    static final String FILE_BATCH_UPLOAD_URL = "/api/open/v1/%s/files/batch";
    static final String WXPUB_AUTHORIZATION_URL = "/api/open/v1/%s/wxpub/buildAuthorizationUrl";
    static final String WXPUB_JSTICKETS_URL = "/api/open/v1/%s/wxpub/jsTickets";
    static final String WXPUB_AUTHCODE_TO_USERINFO_URL = "/api/open/v1/%s/wxpub/getWxAuthorizeUserInfo";
    static final String WXPUB_SEND_SUBSCRIBE_MESSAGE = "/api/open/v1/%s/wxpub/sendMpSubscribeMsg";

    public OpenApiDecodeService(RestTemplate restTemplate, String host) {
        ConvertUtils.register((Converter)new DateLocaleConverter(), Date.class);
        this.restTemplate = restTemplate;
        this.host = host;
        Assert.notNull((Object)host, (String)"\u5f00\u653e\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public WxAppLoginResponse wxAppLogin(String appid, String appSecret, String wxAppId, String code) {
        String requestUrl = String.format(WXAPP_LOGIN_URL, appid);
        WxAppLoginForm form = new WxAppLoginForm(wxAppId, code);
        String query = this.openApiParams(appid, appSecret, this.objectToMap(form), requestUrl).toUrl();
        return this.postForResult(requestUrl, query, form, WxAppLoginResponse.class);
    }

    public WxPubSuccessResponse wxpubBuildAuthorizationUrl(String appid, String appSecret, String wxAppId, String redirectURI, String scope, String state) {
        String requestUrl = String.format(WXPUB_AUTHORIZATION_URL, appid);
        WxPubBuildAuthorizationUrlForm form = new WxPubBuildAuthorizationUrlForm(wxAppId, redirectURI, scope, state);
        String query = this.openApiParams(appid, appSecret, this.objectToMap(form), requestUrl).toUrl();
        return this.postForResult(requestUrl, query, form, WxPubSuccessResponse.class);
    }

    public Map wxpubGetJsTickets(String appid, String appSecret, String wxAppId, String url) {
        String requestUrl = String.format(WXPUB_JSTICKETS_URL, appid);
        WxPubGetJsTicketForm form = new WxPubGetJsTicketForm(wxAppId, url);
        String query = this.openApiParams(appid, appSecret, this.objectToMap(form), requestUrl).toUrl();
        return this.postForResult(requestUrl, query, form, Map.class);
    }

    public WxAuthorizeUserVo wxpubExchangeAuthCodeToUserInfo(String appid, String appSecret, String wxAppId, String code) {
        String requestUrl = String.format(WXPUB_AUTHCODE_TO_USERINFO_URL, appid);
        WxPubExchangeAuthCodeToUserForm form = new WxPubExchangeAuthCodeToUserForm(wxAppId, code);
        String query = this.openApiParams(appid, appSecret, this.objectToMap(form), requestUrl).toUrl();
        return this.postForResult(requestUrl, query, form, WxAuthorizeUserVo.class);
    }

    public BaseSuccessResponse<Integer> sendWxMaSubscribeMessage(String appid, String appSecret, String wxAppId, String templateId, String toUser, String page, List<WxMessageData> data) {
        String requestUrl = String.format(WXAPP_SEND_SUBSCRIBE_MESSAGE, appid);
        WxMaSubscribeMsgForm form = new WxMaSubscribeMsgForm(wxAppId, templateId, toUser, page, data);
        String query = this.openApiParams(appid, appSecret, this.objectToMap(form), requestUrl).toUrl();
        return this.postForResult(requestUrl, query, form, BaseSuccessResponse.class);
    }

    public BaseSuccessResponse<Boolean> sendWxMpSubscribeMessage(String appid, String appSecret, String wxAppId, String templateId, String toUser, String url, String scene, String title, String contentValue, String contentColor, WxMpSubscribeMsgForm.MiniApp miniProgram) {
        String requestUrl = String.format(WXPUB_SEND_SUBSCRIBE_MESSAGE, appid);
        WxMpSubscribeMsgForm form = new WxMpSubscribeMsgForm(wxAppId, templateId, toUser, url, scene, title, contentValue, contentColor);
        form.setMiniProgram(miniProgram);
        String query = this.openApiParams(appid, appSecret, this.objectToMap(form), requestUrl).toUrl();
        return this.postForResult(requestUrl, query, form, BaseSuccessResponse.class);
    }

    protected <T> T postFilesForResult(String requestUrl, String query, Object requestData, Class<T> responseType) {
        String message = "\u672a\u77e5\u9519\u8bef";
        HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
        try {
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new OpenApiResponseErrorHandler());
            ResponseEntity resultResponseEntity = this.restTemplate.postForEntity(this.getHostRequestUrl(requestUrl, query), requestData, Result.class, new Object[0]);
            if (resultResponseEntity != null) {
                Result result = (Result)resultResponseEntity.getBody();
                if (result != null && result.getData() != null) {
                    if (result.getData() instanceof Map) {
                        return this.mapToObject((Map)result.getData(), responseType);
                    }
                    return (T)result.getData();
                }
                statusCode = resultResponseEntity.getStatusCode();
            }
        }
        catch (RestClientException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        throw new HttpServerErrorException(statusCode, message);
    }

    protected <T> T postForResult(String requestUrl, String query, Object requestData, Class<T> responseType) {
        String message = "\u672a\u77e5\u9519\u8bef";
        HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
        try {
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new OpenApiResponseErrorHandler());
            Result result = (Result)this.restTemplate.postForObject(this.getHostRequestUrl(requestUrl, query), requestData, Result.class, new Object[0]);
            if (result.getData() != null) {
                if (result.getData() instanceof Map) {
                    return this.mapToObject((Map)result.getData(), responseType);
                }
                return (T)result.getData();
            }
        }
        catch (RestClientException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        throw new HttpServerErrorException(statusCode, message);
    }

    protected <T> T getForResult(String requestUrl, String query, Class<T> responseType) {
        String message = "\u672a\u77e5\u9519\u8bef";
        HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
        try {
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new OpenApiResponseErrorHandler());
            Result result = (Result)this.restTemplate.getForObject(this.getHostRequestUrl(requestUrl, query), Result.class, new Object[0]);
            if (result.getData() != null) {
                if (result.getData() instanceof Map) {
                    return this.mapToObject((Map)result.getData(), responseType);
                }
                return (T)result.getData();
            }
        }
        catch (RestClientException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        throw new HttpServerErrorException(statusCode, message);
    }

    protected void putForResult(String requestUrl, String query, Object requestData) {
        String message = "\u672a\u77e5\u9519\u8bef";
        HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
        try {
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new OpenApiResponseErrorHandler());
            this.restTemplate.put(this.getHostRequestUrl(requestUrl, query), requestData, new Object[0]);
        }
        catch (RestClientException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        throw new HttpServerErrorException(statusCode, message);
    }

    protected void deleteForResult(String requestUrl, String query) {
        String message = "\u672a\u77e5\u9519\u8bef";
        HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;
        try {
            this.restTemplate.setErrorHandler((ResponseErrorHandler)new OpenApiResponseErrorHandler());
            this.restTemplate.delete(this.getHostRequestUrl(requestUrl, query), new Object[0]);
        }
        catch (RestClientException ex) {
            ex.printStackTrace();
            message = ex.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        throw new HttpServerErrorException(statusCode, message);
    }

    protected String getHostRequestUrl(String url, String query) {
        return this.host + url + "?" + query;
    }

    protected OpenApiParamsVo openApiParams(String appid, String appSecret, MapOpenApiParams<String, Object> queryParams, String requestUrl) {
        OpenApiParamsVo openApiParamsVo = new OpenApiParamsVo();
        openApiParamsVo.setAppid(appid);
        openApiParamsVo.setTimestamp(System.currentTimeMillis());
        openApiParamsVo.setNonce(RandomStringUtils.randomAlphabetic((int)5));
        String needSignParamString = openApiParamsVo.getNeedSignParamString(Arrays.asList(queryParams));
        openApiParamsVo.setSign(this.signParams(needSignParamString, requestUrl, appSecret));
        return openApiParamsVo;
    }

    protected String signParams(String needSignParamString, String requestUrl, String appSecret) {
        Assert.isTrue((needSignParamString != null && !needSignParamString.equals("") ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u7b7e\u540d\u53c2\u6570\u5217\u8868\u4e3a\u7a7a");
        return Md5Util.MD5Encode((String)String.format("%s&appSecret=%s&url=%s", needSignParamString, appSecret, requestUrl)).toUpperCase();
    }

    protected String getNeedSignParamString(Map<String, ?> paramMap) {
        ArrayList<String> fields = new ArrayList<String>(paramMap.keySet());
        fields.sort((Comparator<String>)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty(fields)) {
            for (int i = 0; i < fields.size(); ++i) {
                String field = (String)fields.get(i);
                Object fieldValue = paramMap.get(field);
                if (fieldValue == null) continue;
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(field).append("=").append(fieldValue);
            }
        }
        return sb.toString();
    }

    protected <E> E mapToObject(Map<String, Object> map, Class<E> beanClass) throws Exception {
        if (map == null) {
            return null;
        }
        if (beanClass == Map.class) {
            return (E)map;
        }
        E obj = beanClass.newInstance();
        BeanUtils.populate(obj, map);
        return obj;
    }

    protected MapOpenApiParams<String, Object> objectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        BeanMap beanMap = new BeanMap(obj);
        MapOpenApiParams<String, Object> result = new MapOpenApiParams<String, Object>();
        for (Object keyObject : beanMap.keySet()) {
            String key = keyObject.toString();
            if ("class".equalsIgnoreCase(key)) continue;
            result.put(key, beanMap.get(key));
        }
        return result;
    }

    public static class BaseSuccessResponse<T> {
        T success;

        public T getSuccess() {
            return this.success;
        }

        public void setSuccess(T success) {
            this.success = success;
        }
    }

    public static class WxPubSuccessResponse {
        String success;

        public String getSuccess() {
            return this.success;
        }

        public void setSuccess(String success) {
            this.success = success;
        }
    }

    public class WxPubExchangeAuthCodeToUserForm {
        String wxAppid;
        String code;

        public WxPubExchangeAuthCodeToUserForm(String wxAppid, String code) {
            this.wxAppid = wxAppid;
            this.code = code;
        }

        public String getWxAppid() {
            return this.wxAppid;
        }

        public void setWxAppid(String wxAppid) {
            this.wxAppid = wxAppid;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public class WxPubGetJsTicketForm {
        String wxAppid;
        String requestUrl;

        public WxPubGetJsTicketForm(String wxAppid, String requestUrl) {
            this.wxAppid = wxAppid;
            this.requestUrl = requestUrl;
        }

        public String getWxAppid() {
            return this.wxAppid;
        }

        public void setWxAppid(String wxAppid) {
            this.wxAppid = wxAppid;
        }

        public String getRequestUrl() {
            return this.requestUrl;
        }

        public void setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
        }
    }

    public class WxPubBuildAuthorizationUrlForm {
        String wxAppid;
        String redirectURI;
        String scope;
        String state;

        public WxPubBuildAuthorizationUrlForm(String wxAppid, String redirectURI, String scope, String state) {
            this.wxAppid = wxAppid;
            this.redirectURI = redirectURI;
            this.scope = scope;
            this.state = state;
        }

        public String getWxAppid() {
            return this.wxAppid;
        }

        public void setWxAppid(String wxAppid) {
            this.wxAppid = wxAppid;
        }

        public String getRedirectURI() {
            return this.redirectURI;
        }

        public void setRedirectURI(String redirectURI) {
            this.redirectURI = redirectURI;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }
    }

    public static class WxAppLoginResponse {
        String openid;
        String sessionKey;
        String unionid;
        String tag = "\u6765\u81ealoginResponse";

        public String getOpenid() {
            return this.openid;
        }

        public void setOpenid(String openid) {
            this.openid = openid;
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public void setSessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
        }

        public String getUnionid() {
            return this.unionid;
        }

        public void setUnionid(String unionid) {
            this.unionid = unionid;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }

    public class WxAppLoginForm {
        String wxAppid;
        String code;

        public WxAppLoginForm(String wxAppId, String code) {
            this.wxAppid = wxAppId;
            this.code = code;
        }

        public String getWxAppid() {
            return this.wxAppid;
        }

        public void setWxAppid(String wxAppid) {
            this.wxAppid = wxAppid;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }
}

