/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.mybatis.param;

import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

public class PageParams {
    @ApiModelProperty(value="\u5206\u9875\u7801", example="1")
    protected Integer p = 1;
    @ApiModelProperty(value="\u9875\u9762\u5927\u5c0f\uff0c\u9ed8\u8ba420", example="20")
    protected Integer ps = 20;
    @ApiModelProperty(value="\u5206\u9875\u7801", example="0")
    protected Integer offset;
    @ApiModelProperty(value="\u9875\u9762\u5927\u5c0f\uff0c\u9ed8\u8ba420", example="20")
    protected Integer limit;
    @ApiModelProperty(value="\u6392\u5e8fsortBy", example="createdTime")
    protected String sby;
    @ApiModelProperty(value="\u5347\u964d\u5e8f", example="desc")
    protected String ord;

    public PageParams() {
    }

    public PageParams(Integer offset, Integer limit) {
        this.offset = offset;
        this.limit = limit;
    }

    public Integer getOffset() {
        if (this.offset == null && this.p != null) {
            if (this.p < 1) {
                this.p = 1;
            }
            return (this.p - 1) * this.getLimit();
        }
        return this.offset > 0 ? this.offset : 0;
    }

    public Integer getLimit() {
        if (this.limit == null && this.getPs() != null) {
            return this.getPs();
        }
        return this.limit > 0 ? this.limit : 0;
    }

    @ApiModelProperty(value="\u6392\u5e8f\u5408\u8ba1", example="desc", hidden=true)
    public String getOrderByClause() {
        return null;
    }

    public String getOrderByClause(Class entityClass) {
        String property = this.getSby();
        if (!StringUtils.isEmpty((Object)property)) {
            String[] sbySplit = property.split("\\.");
            String prefix = "";
            if (sbySplit.length > 1) {
                prefix = sbySplit[0] + ".";
                Assert.isTrue((sbySplit.length == 2 ? 1 : 0) != 0, (String)"\u6392\u5e8f\u4e0d\u652f\u6301\u591a\u5c42\u7ea7\u5c5e\u6027");
                property = sbySplit[1];
            }
            String column = this.getColumn(entityClass, property);
            if (!StringUtils.isEmpty((Object)this.getOrd()) && column != null) {
                return prefix + column + " " + this.getOrd();
            }
            return column;
        }
        return null;
    }

    private String getColumn(Class entityClass, String property) {
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn column : columnList) {
            if (!column.getProperty().equals(property)) continue;
            return column.getColumn();
        }
        return null;
    }

    public Integer getP() {
        return this.p;
    }

    public void setP(Integer p) {
        this.p = p;
    }

    public Integer getPs() {
        return this.ps;
    }

    public void setPs(Integer ps) {
        this.ps = ps;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getSby() {
        return this.sby;
    }

    public void setSby(String sby) {
        this.sby = sby;
    }

    public String getOrd() {
        return this.ord;
    }

    public void setOrd(String ord) {
        this.ord = ord;
    }
}

