/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.mybatis.intf;

import cn.watsontech.webhelper.mybatis.Mapper;
import cn.watsontech.webhelper.mybatis.intf.Service;
import cn.watsontech.webhelper.mybatis.mapper.BatchInsertModel;
import cn.watsontech.webhelper.mybatis.param.PageParams;
import cn.watsontech.webhelper.mybatis.util.SingleRowMapperResultSetExtractor;
import com.github.pagehelper.PageRowBounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Condition;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

public class BaseService<T, PK>
implements Service<T, PK> {
    Mapper<T> mapper;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public BaseService(Mapper<T> mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean existsWithPrimaryKey(PK key) {
        return this.mapper.existsWithPrimaryKey(key);
    }

    @Override
    public long count(T model) {
        return this.mapper.selectCount(model);
    }

    @Override
    public long countByCondition(Condition condition) {
        return this.mapper.selectCountByCondition(condition);
    }

    @Override
    public int insert(T model) {
        return this.mapper.useGenerateKeyInsert(model);
    }

    @Override
    public int insertSelective(T model) {
        return this.mapper.useGenerateKeyInsertSelective(model);
    }

    @Override
    public int insertList(List<T> models) {
        return this.mapper.insertList(models);
    }

    @Override
    public int insertListIgnoreConflict(List<T> models) {
        return this.mapper.insertListIgnoreConflict(models);
    }

    @Override
    public int insertSelectiveListIgnoreConflict(List<String> insertPropertis, List<T> models) {
        if (models == null) {
            return 0;
        }
        List noNullModels = models.stream().filter(model -> model != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(noNullModels)) {
            return 0;
        }
        Object firstModel = noNullModels.get(0);
        Set columnList = EntityHelper.getColumns(firstModel.getClass());
        ArrayList<String> insertColumns = new ArrayList<String>();
        for (EntityColumn column : columnList) {
            if (column.isId() || !column.isInsertable() || !insertPropertis.contains(column.getProperty())) continue;
            insertColumns.add(column.getColumn());
        }
        return this.mapper.insertSelectiveListIgnoreConflict(new BatchInsertModel(insertColumns, noNullModels));
    }

    @Override
    public int deleteByPrimaryKey(PK id) {
        return this.mapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByIds(List<PK> ids) {
        return this.mapper.deleteByIds(StringUtils.collectionToCommaDelimitedString(ids));
    }

    @Override
    public int deleteByCondition(Condition condition) {
        return this.mapper.deleteByCondition(condition);
    }

    @Override
    public int updateByCondition(T model, Condition condition) {
        return this.mapper.updateByCondition(model, condition);
    }

    @Override
    public int updateByConditionSelective(T model, Condition condition) {
        return this.mapper.updateByConditionSelective(model, condition);
    }

    @Override
    public int updateByPrimaryKey(T model) {
        return this.mapper.updateByPrimaryKey(model);
    }

    @Override
    public int updateByPrimaryKeySelective(T model) {
        return this.mapper.updateByPrimaryKeySelective(model);
    }

    @Override
    public T selectByPrimaryKey(PK id) {
        return (T)this.mapper.selectByPrimaryKey(id);
    }

    @Override
    public T selectOne(T model) {
        return (T)this.mapper.selectOne(model);
    }

    @Override
    public List<T> selectAll() {
        return this.mapper.selectAll();
    }

    @Override
    public T selectFirst(T model) {
        List objects = this.mapper.selectByRowBounds(model, new RowBounds(0, 1));
        return CollectionUtils.isEmpty((Collection)objects) ? null : (T)objects.get(0);
    }

    @Override
    public T selectFirstByCondition(Condition condition) {
        List<T> objects = this.selectByCondition(condition);
        return CollectionUtils.isEmpty(objects) ? null : (T)objects.get(0);
    }

    @Override
    public List<T> select(T model) {
        return this.mapper.select(model);
    }

    @Override
    public List<T> selectForStartPage(T model, Integer pageNum, Integer pageSize) {
        return this.mapper.selectByRowBounds(model, new RowBounds((pageNum - 1) * pageSize, pageSize.intValue()));
    }

    @Override
    public List<T> selectByIds(List<PK> ids) {
        return this.mapper.selectByIds(StringUtils.collectionToCommaDelimitedString(ids));
    }

    @Override
    public List<T> selectByCondition(Condition condition) {
        return this.mapper.selectByCondition(condition);
    }

    @Override
    public List<T> selectByConditionForStartPage(Condition condition, Integer pageNum, Integer pageSize) {
        return this.selectByConditionForOffsetAndLimit(condition, (pageNum - 1) * pageSize, pageSize, false);
    }

    @Override
    public List<T> selectByConditionForStartPage(Condition condition, Integer pageNum, Integer pageSize, Boolean count) {
        return this.selectByConditionForOffsetAndLimit(condition, (pageNum - 1) * pageSize, pageSize, count);
    }

    @Override
    public List<T> selectByConditionForOffsetAndLimit(Condition condition, Integer offset, Integer limit, Boolean count) {
        PageRowBounds rowBounds = new PageRowBounds(offset.intValue(), limit.intValue());
        rowBounds.setCount(count);
        return this.mapper.selectByExampleAndRowBounds(condition, (RowBounds)rowBounds);
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) {
        return (T)this.jdbcTemplate.queryForObject(sql, requiredType, args);
    }

    @Override
    public <T> T queryForSingleColumn(Class<T> returnClass, String sql, Object[] args) {
        return (T)this.jdbcTemplate.query(sql, args, new SingleRowMapperResultSetExtractor(new SingleColumnRowMapper(returnClass)));
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) {
        List<Map<String, Object>> results = this.queryForList(sql, args);
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, results.size());
        }
        return results.iterator().next();
    }

    @Override
    public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) {
        return this.jdbcTemplate.queryForList(sql, args, elementType);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object[] args) {
        return this.jdbcTemplate.queryForList(sql, args);
    }

    @Override
    public int[] batchInsertTable(String tableName, List<String> columns, List<Object[]> datas, boolean ignoreConflict) {
        Object[] paramMarks = new String[columns.size()];
        Arrays.fill(paramMarks, "?");
        return this.jdbcTemplate.batchUpdate(String.format("insert %s into `%s` (%s) values (%s)", ignoreConflict ? "ignore" : "", tableName, StringUtils.collectionToDelimitedString(columns, (String)",", (String)"`", (String)"`"), StringUtils.arrayToCommaDelimitedString((Object[])paramMarks)), datas);
    }

    @Override
    public int insertTable(String tableName, List<String> columns, List<Object> datas, boolean ignoreConflict) {
        Object[] paramMarks = new String[columns.size()];
        Arrays.fill(paramMarks, "?");
        return this.jdbcTemplate.update(String.format("insert %s into `%s` (%s) values (%s)", ignoreConflict ? "ignore" : "", tableName, StringUtils.collectionToDelimitedString(columns, (String)",", (String)"`", (String)"`"), StringUtils.arrayToCommaDelimitedString((Object[])paramMarks)), datas.toArray());
    }

    @Override
    public int insertTable(String tableName, Map<String, Object> datas, boolean ignoreConflict) {
        Assert.notNull(datas, (String)"datas cannot be null");
        Set<String> keys = datas.keySet();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (String key : keys) {
            columns.add(key);
            values.add(datas.get(key));
        }
        return this.insertTable(tableName, columns, values, ignoreConflict);
    }

    @Override
    public int updateTable(String sql, Object ... args) {
        return this.jdbcTemplate.update(sql, args);
    }

    @Override
    public void executeSql(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    protected Condition wrapCondition(Class claz) {
        return this.wrapCondition(claz, null, true);
    }

    @Override
    public Condition wrapCondition(Class claz, String[] properties) {
        return this.wrapCondition(claz, properties, true);
    }

    @Override
    public Condition wrapCondition(Class claz, String[] properties, boolean withEnabledFilter) {
        Condition condition = new Condition(claz);
        if (properties != null) {
            condition.selectProperties(properties);
        } else {
            condition.excludeProperties(new String[]{"createdBy", "createdByName", "version", "modifiedBy", "modifiedTime"});
        }
        if (withEnabledFilter) {
            condition.createCriteria().andEqualTo("enabled", (Object)true);
        }
        return condition;
    }

    protected <PKI> Condition wrapCondition(Class claz, PKI id) {
        Condition condition = new Condition(claz);
        condition.createCriteria().andEqualTo("id", id);
        return condition;
    }

    protected <PKI, PKC> Condition wrapCondition(Class claz, PKI id, PKC createdBy) {
        Condition condition = new Condition(claz);
        condition.createCriteria().andEqualTo("id", id).andEqualTo("createdBy", createdBy);
        return condition;
    }

    public static PageRowBounds wrapPageRowBounds(PageParams params) {
        return BaseService.wrapPageRowBounds(params, true);
    }

    public static PageRowBounds wrapPageRowBounds(PageParams params, boolean count) {
        PageRowBounds rowBounds = new PageRowBounds(params.getOffset() != null ? params.getOffset() : 0, params.getLimit() != null ? params.getLimit() : 20);
        rowBounds.setCount(Boolean.valueOf(count));
        return rowBounds;
    }
}

