/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.mybatis.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={JSON.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class MySqlJSONTypeHandler
extends BaseTypeHandler<JSON> {
    public void setNonNullParameter(PreparedStatement ps, int i, JSON parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, String.valueOf(parameter.toJSONString()));
    }

    public JSON getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String sqlJson = rs.getString(columnName);
        if (null != sqlJson) {
            try {
                return JSONObject.parseObject((String)sqlJson);
            }
            catch (Exception ex) {
                return JSONArray.parseArray((String)sqlJson);
            }
        }
        return null;
    }

    public JSON getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String sqlJson = rs.getString(columnIndex);
        if (null != sqlJson) {
            try {
                return JSONObject.parseObject((String)sqlJson);
            }
            catch (Exception ex) {
                return JSONArray.parseArray((String)sqlJson);
            }
        }
        return null;
    }

    public JSON getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String sqlJson = cs.getString(columnIndex);
        if (null != sqlJson) {
            try {
                return JSONObject.parseObject((String)sqlJson);
            }
            catch (Exception ex) {
                return JSONArray.parseArray((String)sqlJson);
            }
        }
        return null;
    }
}

