/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.datasource;

import cn.watsontech.webhelper.datasource.DBContextHolder;
import cn.watsontech.webhelper.datasource.UseDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.Ordered;

@Aspect
public class DataSourceAspect
implements Ordered {
    Log log = LogFactory.getLog(DataSourceAspect.class);

    public int getOrder() {
        return -10;
    }

    @Before(value="readPointcut()")
    public void doBefore(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        UseDatabase useDatabase = methodSignature.getMethod().getAnnotation(UseDatabase.class);
        this.log.info((Object)String.format("DataSourceAspect doBefore \u7c7b\u65b9\u6cd5\uff1a%s\uff0c\u6ce8\u89e3useDatabase: %s", methodSignature.toShortString(), useDatabase));
        if (useDatabase != null) {
            DBContextHolder.set(useDatabase.dbType());
        }
    }

    @Pointcut(value="@annotation(cn.watsontech.webhelper.datasource.UseDatabase)")
    public void readPointcut() {
    }

    @Pointcut(value="bsInsertPointcut() || bsUpdatePointcut() || bsDeletePointcut()")
    public void baseServicePointcut() {
    }

    @Pointcut(value="execution(public * cn.watsontech.webhelper.service.BaseService.insert*(..))")
    public void bsInsertPointcut() {
    }

    @Pointcut(value="execution(public * cn.watsontech.webhelper.service.BaseService.update*(..))")
    public void bsUpdatePointcut() {
    }

    @Pointcut(value="execution(public * cn.watsontech.webhelper.service.BaseService.delete*(..))")
    public void bsDeletePointcut() {
    }
}

