/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.mybatis.param;

import cn.watsontech.webhelper.mybatis.param.PageParams;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;

public class BasicPageParams
implements PageParams {
    @ApiModelProperty(value="\u5206\u9875\u7801", example="0")
    protected Integer offset;
    @ApiModelProperty(value="\u9875\u9762\u5927\u5c0f\uff0c\u9ed8\u8ba420", example="20")
    protected Integer limit;
    @ApiModelProperty(value="\u6392\u5e8fsortBy", example="createdTime")
    protected String sby;
    @ApiModelProperty(value="\u5347\u964d\u5e8f", example="desc")
    protected PageParams.Order ord;

    public BasicPageParams() {
    }

    public BasicPageParams(Integer offset, Integer limit) {
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public Integer getOffset() {
        if (this.offset == null) {
            return 0;
        }
        return this.offset > 0 ? this.offset : 0;
    }

    @Override
    public Integer getLimit() {
        if (this.limit == null) {
            return 10;
        }
        return this.limit > 0 ? this.limit : 0;
    }

    @ApiModelProperty(value="\u6392\u5e8f\u5408\u8ba1", example="desc", hidden=true)
    public String getOrderByClause() {
        String sby = this.getSby();
        if (!StringUtils.isEmpty((Object)sby) && !sby.contains(" ")) {
            return sby + " " + this.getStringValue((Object)this.getOrd());
        }
        return "";
    }

    private String getStringValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String getOrderByClause(Class entityClass) {
        String property = this.getSby();
        if (!StringUtils.isEmpty((Object)property)) {
            String[] sbySplit = property.split("\\.");
            String prefix = "";
            if (sbySplit.length > 1) {
                prefix = sbySplit[0] + ".";
                Assert.isTrue((sbySplit.length == 2 ? 1 : 0) != 0, (String)"\u6392\u5e8f\u4e0d\u652f\u6301\u591a\u5c42\u7ea7\u5c5e\u6027");
                property = sbySplit[1];
            }
            String column = this.getColumn(entityClass, property);
            if (this.getOrd() != null && column != null) {
                return prefix + column + " " + this.getOrd().name();
            }
            return column;
        }
        return null;
    }

    private String getColumn(Class entityClass, String property) {
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn column : columnList) {
            if (!column.getProperty().equals(property)) continue;
            return column.getColumn();
        }
        return null;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public String getSby() {
        return this.sby;
    }

    public void setSby(String sby) {
        this.sby = sby;
    }

    @Override
    public PageParams.Order getOrd() {
        return this.ord;
    }

    public void setOrd(PageParams.Order ord) {
        this.ord = ord;
    }
}

