/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.mybatis.mapper;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SelectKeyHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

public class UseGenerateKeyInsertProvider
extends MapperTemplate {
    public UseGenerateKeyInsertProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String useGenerateKeyInsert(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        EntityColumn logicDeleteColumn = SqlHelper.getLogicDeleteColumn((Class)entityClass);
        this.processKey(sql, entityClass, ms, columnList);
        sql.append(SqlHelper.insertIntoTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append(SqlHelper.insertColumns((Class)entityClass, (boolean)false, (boolean)false, (boolean)false));
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(SqlHelper.getLogicDeletedValue((EntityColumn)column, (boolean)false)).append(",");
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheNotNull((EntityColumn)column, (String)column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlHelper.getIfNotNull((EntityColumn)column, (String)column.getColumnHolder(null, null, ","), (boolean)this.isNotEmpty()));
            }
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheIsNull((EntityColumn)column, (String)(column.getColumnHolder() + ",")));
                continue;
            }
            sql.append(SqlHelper.getIfIsNull((EntityColumn)column, (String)column.getColumnHolder(null, null, ","), (boolean)this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public String useGenerateKeyInsertSelective(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        EntityColumn logicDeleteColumn = SqlHelper.getLogicDeleteColumn((Class)entityClass);
        this.processKey(sql, entityClass, ms, columnList);
        sql.append(SqlHelper.insertIntoTable((Class)entityClass, (String)this.tableName(entityClass)));
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(column.getColumn()).append(",");
                continue;
            }
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(column.getColumn()).append(",");
                continue;
            }
            sql.append(SqlHelper.getIfNotNull((EntityColumn)column, (String)(column.getColumn() + ","), (boolean)this.isNotEmpty()));
        }
        sql.append("</trim>");
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(SqlHelper.getLogicDeletedValue((EntityColumn)column, (boolean)false)).append(",");
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlHelper.getIfCacheNotNull((EntityColumn)column, (String)column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlHelper.getIfNotNull((EntityColumn)column, (String)column.getColumnHolder(null, null, ","), (boolean)this.isNotEmpty()));
            }
            if (!column.isIdentity()) continue;
            sql.append(SqlHelper.getIfCacheIsNull((EntityColumn)column, (String)(column.getColumnHolder() + ",")));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    private void processKey(StringBuilder sql, Class<?> entityClass, MappedStatement ms, Set<EntityColumn> columnList) {
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (column.isIdentity()) {
                sql.append(SqlHelper.getBindCache((EntityColumn)column));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && "JDBC".equals(column.getGenerator())) continue;
                    throw new MapperException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKeyHelper.newSelectKeyMappedStatement((MappedStatement)ms, (EntityColumn)column, entityClass, (Boolean)this.isBEFORE(), (String)this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (column.getGenIdClass() == null) continue;
            sql.append("<bind name=\"").append(column.getColumn()).append("GenIdBind\" value=\"@tk.mybatis.mapper.genid.GenIdUtil@genId(");
            sql.append("_parameter").append(", '").append(column.getProperty()).append("'");
            sql.append(", @").append(column.getGenIdClass().getCanonicalName()).append("@class");
            sql.append(", '").append(this.tableName(entityClass)).append("'");
            sql.append(", '").append(column.getColumn()).append("')");
            sql.append("\"/>");
        }
    }
}

