/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.mybatis.generator;

import cn.watsontech.webhelper.mybatis.util.Inflector;
import com.google.common.base.CaseFormat;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.ColumnOverride;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.config.IgnoredColumn;
import org.mybatis.generator.config.JDBCConnectionConfiguration;
import org.mybatis.generator.config.JavaClientGeneratorConfiguration;
import org.mybatis.generator.config.JavaModelGeneratorConfiguration;
import org.mybatis.generator.config.ModelType;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.SqlMapGeneratorConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CodeGenerator {
    final String BASE_PACKAGE;
    final String MODEL_PACKAGE;
    final String MAPPER_PACKAGE;
    final String SERVICE_PACKAGE;
    final String SERVICE_IMPL_PACKAGE;
    final String CONTROLLER_PACKAGE;
    final String JDBC_URL;
    final String JDBC_HOST;
    final String JDBC_DB;
    final String JDBC_USERNAME;
    final String JDBC_PASSWORD;
    final String JDBC_DIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    final String PACKAGE_PATH_SERVICE;
    final String PACKAGE_PATH_SERVICE_IMPL;
    final String PACKAGE_PATH_CONTROLLER;
    final String AUTHOR;
    final String DATE = new SimpleDateFormat("yyyy/MM/dd").format(new Date());
    final String COPYRIGHT;
    final List<TableModelParam> tableModelParams;
    String MAPPER_INTERFACE_REFERENCE = "cn.watsontech.webhelper.mybatis.Mapper";
    String PROJECT_PATH = System.getProperty("user.dir");
    String TEMPLATE_FILE_PATH = this.PROJECT_PATH + "/src/test/resources/generator/template";
    String TARGET_JAVA_PATH = "/src/main/java";
    String RESOURCES_PATH = "/src/main/resources";

    public CodeGenerator(String basePackage, String jdbcHost, String jdbcDb, String jdbcUsername, String jdbcPassword, String author, String orgName, List<TableModelParam> tableModelParams) {
        this.BASE_PACKAGE = basePackage;
        this.MODEL_PACKAGE = this.BASE_PACKAGE + ".entity";
        this.MAPPER_PACKAGE = this.BASE_PACKAGE + ".mapper";
        this.SERVICE_PACKAGE = this.BASE_PACKAGE + ".service";
        this.SERVICE_IMPL_PACKAGE = this.SERVICE_PACKAGE + ".impl";
        this.CONTROLLER_PACKAGE = this.BASE_PACKAGE + ".controller.base";
        this.PACKAGE_PATH_SERVICE = this.packageConvertPath(this.SERVICE_PACKAGE);
        this.PACKAGE_PATH_SERVICE_IMPL = this.packageConvertPath(this.SERVICE_IMPL_PACKAGE);
        this.PACKAGE_PATH_CONTROLLER = this.packageConvertPath(this.CONTROLLER_PACKAGE);
        this.JDBC_HOST = jdbcHost;
        this.JDBC_DB = jdbcDb;
        this.JDBC_USERNAME = jdbcUsername;
        this.JDBC_PASSWORD = jdbcPassword;
        this.JDBC_URL = "jdbc:mysql://" + this.JDBC_HOST + "/" + this.JDBC_DB + "?useSSL=false&nullCatalogMeansCurrent=true";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
        this.COPYRIGHT = "Copyright (c) " + dateFormat.format(new Date()) + ". " + orgName;
        this.AUTHOR = author;
        this.tableModelParams = tableModelParams;
    }

    public static ColumnOverride wrapColumnOverride(String column, String javaType) {
        ColumnOverride columnOverride = new ColumnOverride(column);
        columnOverride.setJavaType(javaType);
        return columnOverride;
    }

    public static ColumnOverride wrapColumnOverride(String column, String javaType, String typeHandler) {
        ColumnOverride columnOverride = new ColumnOverride(column);
        columnOverride.setJavaType(javaType);
        columnOverride.setTypeHandler(typeHandler);
        return columnOverride;
    }

    public static IgnoredColumn wrapIgnoredColumn(String column) {
        return new IgnoredColumn(column);
    }

    public void setPROJECT_PATH(String PROJECT_PATH) {
        this.PROJECT_PATH = PROJECT_PATH;
    }

    public void setTEMPLATE_FILE_PATH(String TEMPLATE_FILE_PATH) {
        this.TEMPLATE_FILE_PATH = TEMPLATE_FILE_PATH;
    }

    public void setTARGET_JAVA_PATH(String TARGET_JAVA_PATH) {
        this.TARGET_JAVA_PATH = TARGET_JAVA_PATH;
    }

    public void setRESOURCES_PATH(String RESOURCES_PATH) {
        this.RESOURCES_PATH = RESOURCES_PATH;
    }

    public void setMAPPER_INTERFACE_REFERENCE(String MAPPER_INTERFACE_REFERENCE) {
        this.MAPPER_INTERFACE_REFERENCE = MAPPER_INTERFACE_REFERENCE;
    }

    public void generateJavaCodes(TableModelParam ... tableParams) {
        Assert.notNull((Object)this.JDBC_HOST, (String)"\u6570\u636e\u5e93\u672a\u914d\u7f6e\uff1ajdbc_host");
        Assert.notNull((Object)this.JDBC_DB, (String)"\u6570\u636e\u5e93\u672a\u914d\u7f6e\uff1ajdbc_db");
        Assert.notNull((Object)this.JDBC_USERNAME, (String)"\u6570\u636e\u5e93\u672a\u914d\u7f6e\uff1ajdbc_username");
        Assert.notNull((Object)this.JDBC_PASSWORD, (String)"\u6570\u636e\u5e93\u672a\u914d\u7f6e\uff1ajdbc_password");
        Assert.notNull((Object)"com.mysql.cj.jdbc.Driver", (String)"\u6570\u636e\u5e93\u672a\u914d\u7f6e\uff1ajdbc_driver");
        JDBCConnectionConfiguration jdbcConnectionConfiguration = new JDBCConnectionConfiguration();
        jdbcConnectionConfiguration.setConnectionURL(this.JDBC_URL);
        jdbcConnectionConfiguration.setUserId(this.JDBC_USERNAME);
        jdbcConnectionConfiguration.setPassword(this.JDBC_PASSWORD);
        jdbcConnectionConfiguration.setDriverClass("com.mysql.cj.jdbc.Driver");
        for (TableModelParam tableParam : tableParams) {
            this.genCodeByCustomModelName(tableParam, jdbcConnectionConfiguration);
        }
    }

    public void genCodeByCustomModelName(TableModelParam tableModelParam, JDBCConnectionConfiguration jdbcConnectionConfiguration) {
        String tableName = tableModelParam.getTableName();
        String modelName = tableModelParam.getModelName();
        String primaryKeyType = tableModelParam.getPrimaryKeyType();
        this.genModelAndMapper(tableName, modelName, tableModelParam.isWithSwagger(), tableModelParam.isBeanBuilderMode(), tableModelParam.getColumnOverrides(), tableModelParam.getIgnoredColumns(), tableModelParam.isGeneratedKey(), jdbcConnectionConfiguration, tableModelParam.getImplementationPackages());
        this.genService(tableName, modelName, primaryKeyType);
        this.genController(tableName, modelName, primaryKeyType, tableModelParam.getApiPrefix());
    }

    public void genModelAndMapper(String tableName, String modelName, boolean withSwagger, boolean beanBuilderMode, List<ColumnOverride> columnOverrides, List<IgnoredColumn> ignoredColumns, boolean isGeneratedKey, JDBCConnectionConfiguration jdbcConnectionConfiguration) {
        this.genModelAndMapper(tableName, modelName, withSwagger, beanBuilderMode, columnOverrides, ignoredColumns, isGeneratedKey, jdbcConnectionConfiguration, null);
    }

    public void genModelAndMapper(String tableName, String modelName, boolean withSwagger, boolean beanBuilderMode, List<ColumnOverride> columnOverrides, List<IgnoredColumn> ignoredColumns, boolean isGeneratedKey, JDBCConnectionConfiguration jdbcConnectionConfiguration, String implementationPackages) {
        MyBatisGenerator generator;
        ArrayList warnings;
        Context context = new Context(ModelType.FLAT);
        context.setId("mybatis");
        context.setTargetRuntime("MyBatis3Simple");
        context.addProperty("beginningDelimiter", "`");
        context.addProperty("endingDelimiter", "`");
        context.setJdbcConnectionConfiguration(jdbcConnectionConfiguration);
        PluginConfiguration pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setConfigurationType("tk.mybatis.mapper.generator.MapperPlugin");
        pluginConfiguration.addProperty("mappers", this.MAPPER_INTERFACE_REFERENCE);
        context.addPluginConfiguration(pluginConfiguration);
        if (withSwagger) {
            pluginConfiguration = new PluginConfiguration();
            pluginConfiguration.setConfigurationType("mybatis.generator.plugins.GeneratorSwagger2Doc");
            pluginConfiguration.addProperty("apiModelAnnotationPackage", "io.swagger.annotations.ApiModel");
            pluginConfiguration.addProperty("apiModelPropertyAnnotationPackage", "io.swagger.annotations.ApiModelProperty");
            context.addPluginConfiguration(pluginConfiguration);
        }
        if (beanBuilderMode) {
            pluginConfiguration = new PluginConfiguration();
            pluginConfiguration.setConfigurationType("mybatis.generator.plugins.ExtendEntitySetter");
            context.addPluginConfiguration(pluginConfiguration);
        }
        pluginConfiguration = new PluginConfiguration();
        pluginConfiguration.setConfigurationType("cn.watsontech.webhelper.mybatis.generator.plugin.ExtendEntityInterfacePlugin");
        String finalImplementationPackages = "cn.watsontech.webhelper.utils.mybatis.CreatedEntity<" + modelName + ", Long, Long>;";
        if (implementationPackages != null) {
            finalImplementationPackages = finalImplementationPackages + implementationPackages;
        }
        pluginConfiguration.addProperty("extraInterfacePackages", finalImplementationPackages);
        context.addPluginConfiguration(pluginConfiguration);
        JavaModelGeneratorConfiguration javaModelGeneratorConfiguration = new JavaModelGeneratorConfiguration();
        javaModelGeneratorConfiguration.setTargetProject(this.PROJECT_PATH + this.TARGET_JAVA_PATH);
        javaModelGeneratorConfiguration.setTargetPackage(this.MODEL_PACKAGE);
        context.setJavaModelGeneratorConfiguration(javaModelGeneratorConfiguration);
        SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration = new SqlMapGeneratorConfiguration();
        sqlMapGeneratorConfiguration.setTargetProject(this.PROJECT_PATH + this.RESOURCES_PATH);
        sqlMapGeneratorConfiguration.setTargetPackage("Mapping");
        context.setSqlMapGeneratorConfiguration(sqlMapGeneratorConfiguration);
        JavaClientGeneratorConfiguration javaClientGeneratorConfiguration = new JavaClientGeneratorConfiguration();
        javaClientGeneratorConfiguration.setTargetProject(this.PROJECT_PATH + this.TARGET_JAVA_PATH);
        javaClientGeneratorConfiguration.setTargetPackage(this.MAPPER_PACKAGE);
        javaClientGeneratorConfiguration.setConfigurationType("XMLMAPPER");
        context.setJavaClientGeneratorConfiguration(javaClientGeneratorConfiguration);
        TableConfiguration tableConfiguration = new TableConfiguration(context);
        tableConfiguration.setTableName(tableName);
        if (!CollectionUtils.isEmpty(columnOverrides)) {
            columnOverrides.forEach(columnOverride -> tableConfiguration.addColumnOverride(columnOverride));
        }
        if (!CollectionUtils.isEmpty(ignoredColumns)) {
            ignoredColumns.forEach(ignoredColumn -> tableConfiguration.addIgnoredColumn(ignoredColumn));
        }
        if (!StringUtils.isEmpty((Object)modelName)) {
            tableConfiguration.setDomainObjectName(modelName);
        }
        if (isGeneratedKey) {
            tableConfiguration.setGeneratedKey(new GeneratedKey("id", "Mysql", true, null));
        }
        context.addTableConfiguration(tableConfiguration);
        try {
            org.mybatis.generator.config.Configuration config = new org.mybatis.generator.config.Configuration();
            config.addContext(context);
            config.validate();
            boolean overwrite = true;
            DefaultShellCallback callback = new DefaultShellCallback(overwrite);
            warnings = new ArrayList();
            generator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            generator.generate(null);
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Model\u548cMapper\u5931\u8d25", e);
        }
        if (generator.getGeneratedJavaFiles().isEmpty() || generator.getGeneratedXmlFiles().isEmpty()) {
            throw new RuntimeException("\u751f\u6210Model\u548cMapper\u5931\u8d25\uff1a" + warnings);
        }
        if (StringUtils.isEmpty((Object)modelName)) {
            modelName = this.tableNameConvertUpperCamel(tableName);
        }
        System.out.println(modelName + ".java \u751f\u6210\u6210\u529f");
        System.out.println(modelName + "Mapper.java \u751f\u6210\u6210\u529f");
        System.out.println(modelName + "Mapper.xml \u751f\u6210\u6210\u529f");
    }

    public void genService(String tableName, String modelName, String primaryKeyType) {
        try {
            Configuration cfg = this.getConfiguration();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("date", this.DATE);
            data.put("author", this.AUTHOR);
            data.put("copyright", this.COPYRIGHT);
            String modelNameUpperCamel = StringUtils.isEmpty((Object)modelName) ? this.tableNameConvertUpperCamel(tableName) : modelName;
            data.put("modelNameUpperCamel", modelNameUpperCamel);
            data.put("primaryKeyType", primaryKeyType);
            data.put("modelNameLowerCamel", this.tableNameConvertLowerCamel(tableName));
            data.put("basePackage", this.BASE_PACKAGE);
            File file = new File(this.PROJECT_PATH + this.TARGET_JAVA_PATH + this.PACKAGE_PATH_SERVICE + modelNameUpperCamel + "Service.java");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            cfg.getTemplate("service.ftl").process(data, (Writer)new FileWriter(file));
            System.out.println(modelNameUpperCamel + "Service.java \u751f\u6210\u6210\u529f");
            File file1 = new File(this.PROJECT_PATH + this.TARGET_JAVA_PATH + this.PACKAGE_PATH_SERVICE_IMPL + modelNameUpperCamel + "ServiceImpl.java");
            if (!file1.getParentFile().exists()) {
                file1.getParentFile().mkdirs();
            }
            cfg.getTemplate("service-impl.ftl").process(data, (Writer)new FileWriter(file1));
            System.out.println(modelNameUpperCamel + "ServiceImpl.java \u751f\u6210\u6210\u529f");
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Service\u5931\u8d25", e);
        }
    }

    public void genController(String tableName, String modelName, String primaryKeyType, String apiPrefix) {
        String modelNameUpperCamel = StringUtils.isEmpty((Object)modelName) ? this.tableNameConvertUpperCamel(tableName) : modelName;
        File file = new File(this.PROJECT_PATH + this.TARGET_JAVA_PATH + this.PACKAGE_PATH_CONTROLLER + modelNameUpperCamel + "Controller.java");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            return;
        }
        try {
            Configuration cfg = this.getConfiguration();
            if (apiPrefix == null) {
                apiPrefix = "";
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("date", this.DATE);
            data.put("author", this.AUTHOR);
            data.put("copyright", this.COPYRIGHT);
            data.put("baseRequestMapping", apiPrefix + this.modelNameConvertMappingPath(modelNameUpperCamel));
            data.put("modelNameUpperCamel", modelNameUpperCamel);
            data.put("primaryKeyType", primaryKeyType);
            data.put("modelNameLowerCamel", CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, modelNameUpperCamel));
            data.put("basePackage", this.BASE_PACKAGE);
            data.put("currentPackage", this.CONTROLLER_PACKAGE);
            cfg.getTemplate("controller.ftl").process(data, (Writer)new FileWriter(file));
            System.out.println(modelNameUpperCamel + "Controller.java \u751f\u6210\u6210\u529f");
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Controller\u5931\u8d25", e);
        }
    }

    private Configuration getConfiguration() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setDirectoryForTemplateLoading(new File(this.TEMPLATE_FILE_PATH));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
        return cfg;
    }

    private String tableNameConvertLowerCamel(String tableName) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, tableName.toLowerCase());
    }

    private String tableNameConvertUpperCamel(String tableName) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, tableName.toLowerCase());
    }

    private String modelNameConvertMappingPath(String modelName) {
        String tableName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, modelName);
        return this.tableNameConvertMappingPath(tableName);
    }

    private String tableNameConvertMappingPath(String tableName) {
        tableName = tableName.toLowerCase();
        String[] splitedTableNames = tableName.split("_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < splitedTableNames.length; ++i) {
            sb.append("/").append(Inflector.getInstance().pluralize(splitedTableNames[i]));
        }
        return sb.toString();
    }

    private String packageConvertPath(String packageName) {
        return String.format("/%s/", packageName.contains(".") ? packageName.replaceAll("\\.", "/") : packageName);
    }

    public static class TableModelParam {
        String tableName;
        String modelName;
        String apiPrefix;
        String primaryKeyType;
        boolean withSwagger = true;
        boolean beanBuilderMode = true;
        boolean isGeneratedKey = true;
        String implementationPackages;
        List<ColumnOverride> columnOverrides;
        List<IgnoredColumn> ignoredColumns;

        public TableModelParam(String tableName) {
            this.tableName = tableName;
        }

        public TableModelParam(String tableName, String modelName) {
            this.tableName = tableName;
            this.modelName = modelName;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.primaryKeyType = primaryKeyType;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType, String apiPrefix) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.primaryKeyType = primaryKeyType;
            this.apiPrefix = apiPrefix;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType, String apiPrefix, boolean isGeneratedKey) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.primaryKeyType = primaryKeyType;
            this.apiPrefix = apiPrefix;
            this.isGeneratedKey = isGeneratedKey;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType, String apiPrefix, List<ColumnOverride> columnOverrides) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.apiPrefix = apiPrefix;
            this.primaryKeyType = primaryKeyType;
            this.columnOverrides = columnOverrides;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType, String apiPrefix, List<ColumnOverride> columnOverrides, String implementationPackages) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.apiPrefix = apiPrefix;
            this.primaryKeyType = primaryKeyType;
            this.columnOverrides = columnOverrides;
            this.implementationPackages = implementationPackages;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType, String apiPrefix, List<ColumnOverride> columnOverrides, boolean isGeneratedKey) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.apiPrefix = apiPrefix;
            this.primaryKeyType = primaryKeyType;
            this.columnOverrides = columnOverrides;
            this.isGeneratedKey = isGeneratedKey;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType, String apiPrefix, List<ColumnOverride> columnOverrides, List<IgnoredColumn> ignoredColumns) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.apiPrefix = apiPrefix;
            this.primaryKeyType = primaryKeyType;
            this.columnOverrides = columnOverrides;
            this.ignoredColumns = ignoredColumns;
        }

        public TableModelParam(String tableName, String modelName, String primaryKeyType, String apiPrefix, List<ColumnOverride> columnOverrides, List<IgnoredColumn> ignoredColumns, boolean isGeneratedKey) {
            this.tableName = tableName;
            this.modelName = modelName;
            this.apiPrefix = apiPrefix;
            this.primaryKeyType = primaryKeyType;
            this.columnOverrides = columnOverrides;
            this.ignoredColumns = ignoredColumns;
            this.isGeneratedKey = isGeneratedKey;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getPrimaryKeyType() {
            return this.primaryKeyType;
        }

        public String getApiPrefix() {
            return this.apiPrefix;
        }

        public String getImplementationPackages() {
            return this.implementationPackages;
        }

        public List<ColumnOverride> getColumnOverrides() {
            return this.columnOverrides;
        }

        public List<IgnoredColumn> getIgnoredColumns() {
            return this.ignoredColumns;
        }

        public TableModelParam setWithSwagger(boolean withSwagger) {
            this.withSwagger = withSwagger;
            return this;
        }

        public TableModelParam setBeanBuilderMode(boolean beanBuilderMode) {
            this.beanBuilderMode = beanBuilderMode;
            return this;
        }

        public boolean isWithSwagger() {
            return this.withSwagger;
        }

        public boolean isBeanBuilderMode() {
            return this.beanBuilderMode;
        }

        public boolean isGeneratedKey() {
            return this.isGeneratedKey;
        }
    }
}

