/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.mybatis.mapper;

import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.mapperhelper.SqlHelper;

public class BatchInsertProvider
extends MapperTemplate {
    public BatchInsertProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public String insertListIgnoreConflict(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(BatchInsertProvider.insertIgnoreIntoTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlHelper.insertColumns((Class)entityClass, (boolean)true, (boolean)false, (boolean)false));
        sql.append(" VALUES ");
        sql.append("<foreach collection=\"list\" item=\"record\" separator=\",\" >");
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn column : columnList) {
            if (column.isId() || !column.isInsertable()) continue;
            sql.append(column.getColumnHolder("record") + ",");
        }
        sql.append("</trim>");
        sql.append("</foreach>");
        return sql.toString();
    }

    public String insertSelectiveListIgnoreConflict(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(BatchInsertProvider.insertIgnoreIntoTable(entityClass, this.tableName(entityClass)));
        sql.append(BatchInsertProvider.insertColumns(entityClass, true, true, true));
        sql.append(" VALUES ");
        sql.append("<foreach collection=\"_parameter.list\" item=\"record\" separator=\",\" >");
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        Set columnList = EntityHelper.getColumns((Class)entityClass);
        for (EntityColumn column : columnList) {
            if (column.isId() || !column.isInsertable()) continue;
            sql.append(BatchInsertProvider.getIfPresentAndNotNull("record", column, column.getColumnHolder("record", null, ","), this.isNotEmpty()));
        }
        sql.append("</trim>");
        sql.append("</foreach>");
        return sql.toString();
    }

    public static String insertColumns(Class<?> entityClass, boolean skipId, boolean notNull, boolean notEmpty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        sql.append(BatchInsertProvider.insertSelectiveColumns(entityClass));
        sql.append("</trim>");
        return sql.toString();
    }

    public static String insertSelectiveColumns(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append("<choose>");
        sql.append("<when test=\"@cn.watsontech.webhelper.mybatis.mapper.BatchInsertOgnl@hasInsertSelectiveColumns(_parameter.list)\">");
        sql.append("<foreach collection=\"_parameter.list.insertColumns\" item=\"insertColumn\" separator=\",\">");
        sql.append("${insertColumn}");
        sql.append("</foreach>");
        sql.append("</when>");
        sql.append("<otherwise>");
        sql.append(SqlHelper.getAllColumns(entityClass));
        sql.append("</otherwise>");
        sql.append("</choose>");
        return sql.toString();
    }

    public static String getIfPresentAndNotNull(String entityName, EntityColumn column, String contents, boolean empty) {
        StringBuilder sql = new StringBuilder();
        sql.append("<if test=\"");
        sql.append(" @cn.watsontech.webhelper.mybatis.mapper.BatchInsertOgnl@hasInsertSelectiveColumn(_parameter.list, '").append(column.getColumn()).append("')");
        sql.append("\">");
        sql.append(contents);
        sql.append("</if>");
        return sql.toString();
    }

    public static String insertIgnoreIntoTable(Class<?> entityClass, String defaultTableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT IGNORE INTO ");
        sql.append(SqlHelper.getDynamicTableName(entityClass, (String)defaultTableName));
        sql.append(" ");
        return sql.toString();
    }
}

