/*
 * Decompiled with CFR 0.152.
 */
package cn.watsontech.webhelper.datasource;

import cn.watsontech.webhelper.datasource.DBTypeEnum;
import java.util.function.Supplier;

public class DBContextHolder {
    private static final ThreadLocal<DBTypeEnum> contextHolder = ThreadLocal.withInitial(new Supplier<DBTypeEnum>(){

        @Override
        public DBTypeEnum get() {
            return DBTypeEnum.MASTER;
        }
    });

    public static void set(DBTypeEnum dbType) {
        if (dbType != null) {
            contextHolder.set(dbType);
        }
    }

    public static DBTypeEnum get() {
        return contextHolder.get();
    }

    public static void master() {
        DBContextHolder.set(DBTypeEnum.MASTER);
    }

    public static void slave() {
        DBContextHolder.set(DBTypeEnum.SLAVE);
    }
}

