package cn.warpin.thirdPart.tencent.wx.miniapp;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.warpin.thirdPart.tencent.wx.WXCfg;

/**
 * 微信小程序客户端（单例模式）
 */
public enum WxMiniClient {

    INSTANCE;

    private WxMaService wxMaService;


    public WxMaService init() {
        if (wxMaService == null) {
            wxMaService = new WxMaServiceImpl();

            WxMaDefaultConfigImpl config = new WxMaDefaultConfigImpl();
            config.setAppid(WXCfg.APPID);
            config.setSecret(WXCfg.SECRET);
            config.setToken(WXCfg.MINI_TOKEN);
            config.setAesKey(WXCfg.MINI_AES_KEY);
            config.setMsgDataFormat(WXCfg.MINI_MSG_DATA_FMT);
//            Map<String, WxMaConfig> map = new HashMap<>();
//            map.put(WXCfg.APPID, config);

//            wxMaService.setMultiConfigs(map);

            wxMaService.addConfig(WXCfg.APPID, config);


        }
        return wxMaService;
    }
}
