package cn.warpin.thirdPart.tencent.wx.miniapp;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.util.WxMaConfigHolder;
import cn.warpin.thirdPart.tencent.wx.WXCfg;
import cn.warpin.thirdPart.tencent.wx.WXUser;
import cn.warpin.thirdPart.tencent.wx.miniapp.config.WxMaConfiguration;
import cn.warpin.thirdPart.tencent.wx.miniapp.config.WxMaProperties;
import cn.warpin.core.exception.ResultException;
import cn.warpin.core.result.ResCode;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(WxMaProperties.class)
public class WxMiniAction {

    private static final WxMaService client = WxMaConfiguration.getMaService(WXCfg.APPID);


    /**
     * 微信login接口用来获取openId和sessionKey
     *
     * @param code
     * @return
     */
    public static WXUser login(String code) {
        WXUser wxUser = null;
        if (StringUtils.isBlank(code)) {
            return null;
        }
        if (!client.switchover(WXCfg.APPID)) {
            throw new ResultException(ResCode.WX_USER_NOT_EXIST);
        }

        try {
            WxMaJscode2SessionResult session = client.getUserService().getSessionInfo(code);
            wxUser = new WXUser(session);
        } catch (WxErrorException e) {
            throw new ResultException(ResCode.WX_USER_LOGIN_FAILED);
        } finally {
            WxMaConfigHolder.remove();
        }
        return wxUser;
    }

    /**
     * 获取用户信息
     *
     * @param info
     * @return
     */
    public static WxMaUserInfo info(WxRegisterInfo info) {
        if (!client.switchover(WXCfg.APPID)) {
            throw new ResultException(ResCode.WX_USER_NOT_EXIST);
        }
        // 用户信息校验
        if (!client.getUserService().checkUserInfo(info.getSessionKey(), info.getRawData(), info.getSignature())) {
            WxMaConfigHolder.remove();//清理ThreadLocal
            throw new ResultException(ResCode.WX_USER_CHECK_FAILED);
        }

        // 解密用户信息
        WxMaUserInfo userInfo = client.getUserService().getUserInfo(info.getSessionKey(), info.getEncryptedData(), info.getIv());
        WxMaConfigHolder.remove();//清理ThreadLocal
        return userInfo;
    }

    /**
     * 获取用户绑定手机号信息
     *
     * @param info
     * @return
     */
    public static WxMaPhoneNumberInfo phone(WxRegisterInfo info) {
        if (!client.switchover(WXCfg.APPID)) {
            throw new ResultException(ResCode.WX_USER_NOT_EXIST);
        }
        // 用户信息校验
//        if (!client.getUserService().checkUserInfo(info.getSessionKey(), info.getRawData(), info.getSignature())) {
//            WxMaConfigHolder.remove();//清理ThreadLocal
//            throw new ResultException(ResCode.WX_USER_CHECK_FAILED);
//        }
        // 解密
        WxMaPhoneNumberInfo phoneNoInfo = null;
        try {
            phoneNoInfo = client.getUserService().getPhoneNoInfo(info.getCode());
        } catch (WxErrorException e) {
            System.out.println(e);
            throw new RuntimeException(e);
        }

        WxMaConfigHolder.remove();//清理ThreadLocal
        return phoneNoInfo;
    }


}
