package cn.warpin.thirdPart.tencent.cos;

import cn.warpin.core.util.FileUtil;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

public class TencentCos {

//    public static final String COSRESOURCESPATH = "resources";

    // 上传单个文件
    public static String uploadFile(MultipartFile file, String path) throws Exception {
        String filename = SimpleUploadFile.SimpleUploadFileFromStream(file, path);
        return filename;
    }

    /**
     * 上传本地文件到cos
     *
     * @param localPath
     * @param path
     * @return
     * @throws Exception
     */
    public static String uploadLocalFile(String localPath, String path) throws Exception {
        MultipartFile mf = FileUtil.getMultipartFile(localPath);
        SimpleUploadFile.SimpleUploadFileFromStream(mf, path);
        return mf.getOriginalFilename();
    }

    public static void imageZoom(String key, String path, String rate) throws Exception {
        ProcessImage.imageZoom(key, path, rate);
    }

    // 删除文件
    public static void delFile(String fileName) {
        DelFile.DelSingleFile(fileName);
    }

    // 批量删除文件
    public static void delFile(List<String> fileNames) {
        DelFile.BatchDelFile(fileNames);
    }

}
