package cn.warpin.thirdPart.tencent.cos;

import cn.warpin.thirdPart.tencent.cfg.cos.CosCfgBuilder;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.model.GetObjectRequest;
import cn.warpin.thirdPart.tencent.cfg.cos.CosCfg;

import java.io.File;

public class ProcessImage {


    /**
     * 压缩图片到本地
     *
     * @param key  在cos上的文件名称，包含路径
     * @param path 要压缩到的本地路径，包含文件名
     * @param rate 压缩百分比 10p=10% ... 50p=50%
     */
    public static void imageZoom(String key, String path, String rate) {
        CosCfg cfg = CosCfgBuilder.build();
        COSClient cosclient = cfg.getCosClient();
        // bucket名需包含appid
        String bucketName = cfg.bucket;
        GetObjectRequest getObj = new GetObjectRequest(bucketName, key);
        // 宽高缩放50%
        String rule = "imageMogr2/thumbnail/!" + rate;
        getObj.putCustomQueryParameter(rule, null);
        cosclient.getObject(getObj, new File(path));
    }

    public static void main(String[] args) {
        String path = "D:\\resource\\temp\\00ad0b24e9764f4ea6b49d8340e14a1f\\panoramaTest\\52_01.jpg";
        imageZoom("lh/type_0415/52_01.jpg", path, "10p");
    }
}
