/**
 * Copyright 2019 Huawei Technologies Co.,Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use
 * this file except in compliance with the License.  You may obtain a copy of the
 * License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */

package cn.warpin.thirdPart.huawei.obs.obs.services.internal.task;

import cn.warpin.thirdPart.huawei.obs.obs.services.exception.ObsException;
import cn.warpin.thirdPart.huawei.obs.obs.services.model.RestoreObjectRequest;
import cn.warpin.thirdPart.huawei.obs.obs.services.model.RestoreObjectResult;
import cn.warpin.thirdPart.huawei.obs.obs.services.model.TaskCallback;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;

public class BlockRejectedExecutionHandler implements RejectedExecutionHandler {

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        try {
            executor.getQueue().put(r);
        } catch (InterruptedException e) {
            if (r instanceof RunnableFuture) {
                throw new RejectedExecutionException(e);
            }

            ObsException obsException = new ObsException(e.getMessage(), e);
            if (r instanceof RestoreObjectTask) {
                RestoreObjectTask task = (RestoreObjectTask) r;
                task.getProgressStatus().failTaskIncrement();
                TaskCallback<RestoreObjectResult, RestoreObjectRequest> callback = task.getCallback();
                callback.onException(obsException, task.getTaskRequest());
            }
        }
    }
}
