package cn.warpin.thirdPart.huawei.obs;

import cn.warpin.core.constant.Constants;
import cn.warpin.thirdPart.huawei.obs.obs.services.ObsClient;
import cn.warpin.thirdPart.huawei.obs.obs.services.exception.ObsException;
import cn.warpin.thirdPart.huawei.cfg.HWCfgBuilder;
import cn.warpin.thirdPart.huawei.obs.obs.services.model.DeleteObjectsRequest;
import cn.warpin.thirdPart.huawei.obs.obs.services.model.DeleteObjectsResult;
import cn.warpin.thirdPart.huawei.obs.obs.services.model.KeyAndVersion;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

import static cn.warpin.core.constant.Constants.BUCKET;

public class HuaweiObs {

    /**
     * 上传文件
     *
     * @param file
     * @param fileKey
     */
    public static void uploadFile(MultipartFile file, String fileKey) {
        HuaweiObsCfg cfg = HWCfgBuilder.OBSBuilder();
        ObsClient client = ObsClientSingleton.INSTANCE.init(cfg);
        try {
            client.putObject(Constants.BUCKET, fileKey, file.getInputStream(), null);
        } catch (ObsException e) {
            System.out.println("Response Code: " + e.getResponseCode());
            System.out.println("Error Message: " + e.getErrorMessage());
            System.out.println("Error Code:       " + e.getErrorCode());
            System.out.println("Request ID:      " + e.getErrorRequestId());
            System.out.println("Host ID:           " + e.getErrorHostId());
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 下载文件
     *
     * @param keys
     * @return
     */
    public static List<DeleteObjectsResult.DeleteObjectResult> deleteFiles(List<String> keys) {
        HuaweiObsCfg cfg = HWCfgBuilder.OBSBuilder();
        ObsClient client = ObsClientSingleton.INSTANCE.init(cfg);
        DeleteObjectsRequest request = new DeleteObjectsRequest();
        request.setBucketName(Constants.BUCKET);
        request.setQuiet(false);
        KeyAndVersion[] kvs = new KeyAndVersion[keys.size()];
        int index = 0;
        for (String key : keys) {
            kvs[index++] = new KeyAndVersion(key);
        }
        request.setKeyAndVersions(kvs);
        DeleteObjectsResult result = null;
        try {
            result = client.deleteObjects(request);
        } catch (ObsException e) {
            System.out.println("Response Code: " + e.getResponseCode());
            System.out.println("Error Message: " + e.getErrorMessage());
            System.out.println("Error Code:       " + e.getErrorCode());
            System.out.println("Request ID:      " + e.getErrorRequestId());
            System.out.println("Host ID:           " + e.getErrorHostId());
        }

        assert result != null;
        return result.getDeletedObjectResults();
    }

}
